/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.service.impl.ActiveFileSystemItemFactoriesDescriptor;
import org.nuxeo.drive.service.impl.ActiveFileSystemItemFactoryDescriptor;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class ActiveFileSystemItemFactoryRegistry
extends ContributionFragmentRegistry<ActiveFileSystemItemFactoriesDescriptor> {
    private static final Log log = LogFactory.getLog(ActiveFileSystemItemFactoryRegistry.class);
    protected static final String CONTRIBUTION_ID = "activeFileSystemItemFactoriesContrib";
    protected Set<String> activeFactories = new HashSet<String>();

    public String getContributionId(ActiveFileSystemItemFactoriesDescriptor contrib) {
        return CONTRIBUTION_ID;
    }

    public void contributionUpdated(String id, ActiveFileSystemItemFactoriesDescriptor contrib, ActiveFileSystemItemFactoriesDescriptor newOrigContrib) {
        log.trace((Object)String.format("Updating activeFileSystemItemFactories contribution %s.", contrib));
        if (contrib.isMerge()) {
            for (ActiveFileSystemItemFactoryDescriptor factory : contrib.getFactories()) {
                if (this.activeFactories.contains(factory.getName()) && !factory.isEnabled()) {
                    log.trace((Object)String.format("Removing factory %s from active factories.", factory.getName()));
                    this.activeFactories.remove(factory.getName());
                }
                if (this.activeFactories.contains(factory.getName()) || !factory.isEnabled()) continue;
                log.trace((Object)String.format("Adding factory %s to active factories.", factory.getName()));
                this.activeFactories.add(factory.getName());
            }
        } else {
            log.trace((Object)String.format("Clearing active factories as contribution %s doesn't merge.", contrib));
            this.activeFactories.clear();
            for (ActiveFileSystemItemFactoryDescriptor factory : contrib.getFactories()) {
                if (!factory.isEnabled()) continue;
                log.trace((Object)String.format("Adding factory %s to active factories.", factory.getName()));
                this.activeFactories.add(factory.getName());
            }
        }
    }

    public void contributionRemoved(String id, ActiveFileSystemItemFactoriesDescriptor origContrib) {
        log.trace((Object)"Clearing active factories.");
        this.activeFactories.clear();
    }

    public ActiveFileSystemItemFactoriesDescriptor clone(ActiveFileSystemItemFactoriesDescriptor orig) {
        log.trace((Object)String.format("Cloning contribution %s.", orig));
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(orig);
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bis);
            return (ActiveFileSystemItemFactoriesDescriptor)ois.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new ClientRuntimeException(String.format("Cannot clone contribution %s.", orig), (Throwable)e);
        }
    }

    public void merge(ActiveFileSystemItemFactoriesDescriptor src, ActiveFileSystemItemFactoriesDescriptor dst) {
        log.trace((Object)String.format("Merging contribution %s to contribution %s.", src, dst));
        if (src.isMerge() != dst.isMerge()) {
            dst.setMerge(src.isMerge());
        }
        for (ActiveFileSystemItemFactoryDescriptor factory : src.getFactories()) {
            int indexOfFactory = dst.getFactories().indexOf(factory);
            if (indexOfFactory > -1) {
                dst.getFactories().get(indexOfFactory).setEnabled(factory.isEnabled());
                continue;
            }
            dst.getFactories().add(factory);
        }
    }
}

