/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.service.impl.ActiveTopLevelFolderItemFactoryDescriptor;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class ActiveTopLevelFolderItemFactoryRegistry
extends ContributionFragmentRegistry<ActiveTopLevelFolderItemFactoryDescriptor> {
    private static final Log log = LogFactory.getLog(ActiveTopLevelFolderItemFactoryRegistry.class);
    protected static final String CONTRIBUTION_ID = "activeTopLevelFolderItemFactoriesContrib";
    protected String activeFactory;

    public String getContributionId(ActiveTopLevelFolderItemFactoryDescriptor contrib) {
        return CONTRIBUTION_ID;
    }

    public void contributionUpdated(String id, ActiveTopLevelFolderItemFactoryDescriptor contrib, ActiveTopLevelFolderItemFactoryDescriptor newOrigContrib) {
        log.trace((Object)String.format("Updating activeTopLevelFolderItemFactory contribution %s.", contrib));
        log.trace((Object)String.format("Setting active factory to %s.", contrib.getName()));
        this.activeFactory = contrib.getName();
    }

    public void contributionRemoved(String id, ActiveTopLevelFolderItemFactoryDescriptor origContrib) {
        log.trace((Object)"Clearing active factory.");
        this.activeFactory = null;
    }

    public ActiveTopLevelFolderItemFactoryDescriptor clone(ActiveTopLevelFolderItemFactoryDescriptor orig) {
        log.trace((Object)String.format("Cloning contribution %s.", orig));
        ActiveTopLevelFolderItemFactoryDescriptor clone = new ActiveTopLevelFolderItemFactoryDescriptor();
        clone.name = orig.name;
        return clone;
    }

    public void merge(ActiveTopLevelFolderItemFactoryDescriptor src, ActiveTopLevelFolderItemFactoryDescriptor dst) {
        log.trace((Object)String.format("Merging contribution %s to contribution %s.", src, dst));
        if (!StringUtils.isEmpty((String)src.getName()) && !src.getName().equals(dst.getName())) {
            dst.setName(src.getName());
        }
    }
}

