/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations;

import java.io.IOException;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.runtime.transaction.TransactionHelper;

public final class NuxeoDriveOperationHelper {
    private NuxeoDriveOperationHelper() {
    }

    public static void commitAndReopenTransaction() {
        if (TransactionHelper.isTransactionActive()) {
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
    }

    public static void normalizeMimeTypeAndEncoding(Blob blob) throws ParseException {
        String mimeType = blob.getMimeType();
        if (!StringUtils.isEmpty((String)mimeType) && !"null".equals(mimeType)) {
            String charset;
            ContentType contentType = new ContentType(mimeType);
            blob.setMimeType(contentType.getBaseType());
            if (StringUtils.isEmpty((String)blob.getEncoding()) && !StringUtils.isEmpty((String)(charset = contentType.getParameter("charset")))) {
                blob.setEncoding(charset);
            }
        }
    }

    public static Blob asJSONBlob(Object value) throws JsonGenerationException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString(value);
        return StreamingBlob.createFromByteArray((byte[])json.getBytes("UTF-8"), (String)"application/json");
    }
}

