/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.adapter.impl;

import java.util.ArrayList;
import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.RootlessItemException;
import org.nuxeo.drive.adapter.impl.AbstractFileSystemItem;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.trash.TrashService;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractDocumentBackedFileSystemItem
extends AbstractFileSystemItem {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractDocumentBackedFileSystemItem.class);
    protected String repositoryName;
    protected String docId;
    protected String docPath;
    protected String docTitle;

    protected AbstractDocumentBackedFileSystemItem(String factoryName, DocumentModel doc) throws ClientException {
        this(factoryName, doc, false);
    }

    protected AbstractDocumentBackedFileSystemItem(String factoryName, DocumentModel doc, boolean relaxSyncRootConstraint) throws ClientException {
        this(factoryName, null, doc);
        CoreSession docSession = doc.getCoreSession();
        DocumentModel parentDoc = null;
        try {
            DocumentRef parentDocRef = docSession.getParentDocumentRef(doc.getRef());
            if (parentDocRef != null) {
                parentDoc = docSession.getDocument(parentDocRef);
            }
        }
        catch (DocumentSecurityException e) {
            log.debug((Object)String.format("User %s has no READ access on parent of document %s (%s), will throw RootlessItemException.", this.principal.getName(), doc.getPathAsString(), doc.getId()));
        }
        if (parentDoc == null) {
            throw new RootlessItemException();
        }
        FileSystemItem parent = this.getFileSystemItemAdapterService().getFileSystemItem(parentDoc, true, relaxSyncRootConstraint);
        if (parent == null) {
            throw new RootlessItemException();
        }
        this.parentId = parent.getId();
        this.path = parent.getPath() + '/' + this.id;
    }

    protected AbstractDocumentBackedFileSystemItem(String factoryName, FolderItem parentItem, DocumentModel doc) throws ClientException {
        super(factoryName, doc.getCoreSession().getPrincipal());
        String parentPath;
        this.repositoryName = doc.getRepositoryName();
        this.docId = doc.getId();
        this.docPath = doc.getPathAsString();
        this.docTitle = doc.getTitle();
        this.id = this.computeId(this.docId);
        this.creator = (String)((Object)doc.getPropertyValue("dc:creator"));
        this.creationDate = (Calendar)doc.getPropertyValue("dc:created");
        this.lastModificationDate = (Calendar)doc.getPropertyValue("dc:modified");
        CoreSession docSession = doc.getCoreSession();
        this.canRename = docSession.hasPermission(doc.getRef(), "WriteProperties");
        boolean bl = this.canDelete = docSession.hasPermission(doc.getRef(), "Remove") && docSession.hasPermission(doc.getParentRef(), "RemoveChildren");
        if (parentItem != null) {
            this.parentId = parentItem.getId();
            parentPath = parentItem.getPath();
        } else {
            this.parentId = null;
            parentPath = "";
        }
        this.path = parentPath + '/' + this.id;
    }

    protected AbstractDocumentBackedFileSystemItem() {
    }

    @Override
    public void delete() throws ClientException {
        ArrayList<DocumentModel> docs = new ArrayList<DocumentModel>();
        DocumentModel doc = this.getDocument(this.getSession());
        docs.add(doc);
        this.getTrashService().trashDocuments(docs);
    }

    @Override
    public boolean canMove(FolderItem dest) throws ClientException {
        if (!this.canDelete) {
            return false;
        }
        AbstractDocumentBackedFileSystemItem docBackedDest = (AbstractDocumentBackedFileSystemItem)((Object)dest);
        String destRepoName = docBackedDest.getRepositoryName();
        IdRef destDocRef = new IdRef(docBackedDest.getDocId());
        CoreSession session = this.repositoryName.equals(destRepoName) ? this.getSession() : this.getSession(destRepoName);
        return session.hasPermission((DocumentRef)destDocRef, "AddChildren");
    }

    @Override
    public FileSystemItem move(FolderItem dest) throws ClientException {
        IdRef sourceDocRef = new IdRef(this.docId);
        AbstractDocumentBackedFileSystemItem docBackedDest = (AbstractDocumentBackedFileSystemItem)((Object)dest);
        String destRepoName = docBackedDest.getRepositoryName();
        IdRef destDocRef = new IdRef(docBackedDest.getDocId());
        if (this.repositoryName.equals(destRepoName)) {
            CoreSession session = this.getSession();
            DocumentModel movedDoc = session.move((DocumentRef)sourceDocRef, (DocumentRef)destDocRef, null);
            session.save();
            return this.getFileSystemItemAdapterService().getFileSystemItem(movedDoc, dest);
        }
        throw new UnsupportedOperationException("Multi repository move is not supported yet.");
    }

    protected CoreSession getSession() throws ClientException {
        return this.getSession(this.repositoryName);
    }

    protected final String computeId(String docId) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getId());
        sb.append(this.repositoryName);
        sb.append("#");
        sb.append(docId);
        return sb.toString();
    }

    protected String getRepositoryName() {
        return this.repositoryName;
    }

    protected String getDocId() {
        return this.docId;
    }

    protected String getDocPath() {
        return this.docPath;
    }

    protected DocumentModel getDocument(CoreSession session) throws ClientException {
        return session.getDocument((DocumentRef)new IdRef(this.docId));
    }

    protected void updateLastModificationDate(DocumentModel doc) throws ClientException {
        this.lastModificationDate = (Calendar)doc.getPropertyValue("dc:modified");
    }

    protected TrashService getTrashService() {
        return (TrashService)Framework.getLocalService(TrashService.class);
    }

    @Override
    protected void setId(String id) {
        try {
            super.setId(id);
            String[] idFragments = this.parseFileSystemId(id);
            this.factoryName = idFragments[0];
            this.repositoryName = idFragments[1];
            this.docId = idFragments[2];
        }
        catch (ClientException e) {
            throw new ClientRuntimeException("Cannot set id as it cannot be parsed.", (Throwable)e);
        }
    }

    protected String[] parseFileSystemId(String id) throws ClientException {
        String[] idFragments = id.split("#");
        if (idFragments.length != 3) {
            throw new ClientException(String.format("FileSystemItem id %s is not valid. Should match the 'fileSystemItemFactoryName#repositoryName#docId' pattern.", id));
        }
        return idFragments;
    }
}

