/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.RootlessItemException;
import org.nuxeo.drive.service.FileSystemChangeFinder;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.drive.service.FileSystemItemChange;
import org.nuxeo.drive.service.NuxeoDriveEvents;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.SynchronizationRoots;
import org.nuxeo.drive.service.TooManyChangesException;
import org.nuxeo.drive.service.impl.FileSystemItemChangeImpl;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.runtime.api.Framework;

public class AuditChangeFinder
implements FileSystemChangeFinder {
    private static final long serialVersionUID = 1963018967324857522L;
    private static final Log log = LogFactory.getLog(AuditChangeFinder.class);

    @Override
    public List<FileSystemItemChange> getFileSystemChanges(CoreSession session, Set<IdRef> lastActiveRootRefs, SynchronizationRoots activeRoots, long lastSuccessfulSyncDate, long syncDate, int limit) throws ClientException, TooManyChangesException {
        String principalName = session.getPrincipal().getName();
        ArrayList<FileSystemItemChange> changes = new ArrayList<FileSystemItemChange>();
        List<LogEntry> entries = this.queryAuditEntries(session, activeRoots, lastSuccessfulSyncDate, syncDate, limit);
        for (LogEntry entry : entries) {
            if (!NuxeoDriveEvents.EVENT_CATEGORY.equals(entry.getCategory())) continue;
            log.debug((Object)String.format("Detected sync root change for user '%s' in audit log: invalidating the root cache and refetching the changes.", principalName));
            NuxeoDriveManager driveManager = (NuxeoDriveManager)Framework.getLocalService(NuxeoDriveManager.class);
            driveManager.invalidateSynchronizationRootsCache(principalName);
            Map<String, SynchronizationRoots> synchronizationRoots = driveManager.getSynchronizationRoots(session.getPrincipal());
            SynchronizationRoots updatedActiveRoots = synchronizationRoots.get(session.getRepositoryName());
            entries = this.queryAuditEntries(session, updatedActiveRoots, lastSuccessfulSyncDate, syncDate, limit);
            break;
        }
        if (entries.size() >= limit) {
            throw new TooManyChangesException("Too many changes found in the audit logs.");
        }
        for (LogEntry entry : entries) {
            FileSystemItemChange change = null;
            IdRef docRef = new IdRef(entry.getDocUUID());
            ExtendedInfo fsIdInfo = (ExtendedInfo)entry.getExtendedInfos().get("fileSystemItemId");
            if (fsIdInfo != null) {
                log.debug((Object)String.format("Found extended info in audit log entry, document %s has been deleted or is an unregistered synchronization root.", docRef));
                boolean isChangeSet = false;
                if (session.exists((DocumentRef)docRef) && (change = this.getFileSystemItemChange(session, (DocumentRef)docRef, entry, (String)fsIdInfo.getValue(String.class))) != null) {
                    isChangeSet = true;
                }
                if (!isChangeSet) {
                    log.debug((Object)String.format("Document %s doesn't exist or is not adaptable as a FileSystemItem, only providing the FileSystemItem id and name to the FileSystemItemChange entry.", docRef));
                    String fsId = (String)fsIdInfo.getValue(String.class);
                    String fsName = (String)((ExtendedInfo)entry.getExtendedInfos().get("fileSystemItemName")).getValue(String.class);
                    change = new FileSystemItemChangeImpl(entry.getEventId(), entry.getEventDate().getTime(), entry.getRepositoryId(), entry.getDocUUID(), fsId, fsName);
                }
                log.debug((Object)String.format("Adding FileSystemItemChange entry for document %s to the change summary.", docRef));
                changes.add(change);
                continue;
            }
            log.debug((Object)String.format("No extended info found in audit log entry, document %s has not been deleted nor is an unregistered synchronization root.", docRef));
            if (!session.exists((DocumentRef)docRef)) {
                log.debug((Object)String.format("Document %s doesn't exist, not adding any entry to the change summary.", docRef));
                continue;
            }
            change = this.getFileSystemItemChange(session, (DocumentRef)docRef, entry, null);
            if (change == null) {
                log.debug((Object)String.format("Document %s is not adaptable as a FileSystemItem, not adding any entry to the change summary.", docRef));
                continue;
            }
            log.debug((Object)String.format("Adding FileSystemItemChange entry for document %s to the change summary.", docRef));
            changes.add(change);
        }
        return changes;
    }

    @Override
    public long getCurrentDate() {
        long now = System.currentTimeMillis();
        return now - now % 1000L;
    }

    protected List<LogEntry> queryAuditEntries(CoreSession session, SynchronizationRoots activeRoots, long lastSuccessfulSyncDate, long syncDate, int limit) {
        AuditReader auditService = (AuditReader)Framework.getLocalService(AuditReader.class);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("repositoryId", session.getRepositoryName());
        StringBuilder auditQuerySb = new StringBuilder("from LogEntry log where ");
        auditQuerySb.append("log.repositoryId = :repositoryId");
        auditQuerySb.append(" and ");
        auditQuerySb.append("(");
        if (!activeRoots.getPaths().isEmpty()) {
            auditQuerySb.append("(");
            auditQuerySb.append("log.category = 'eventDocumentCategory'");
            auditQuerySb.append(" and (log.eventId = 'documentCreated' or log.eventId = 'documentModified' or log.eventId = 'documentMoved' or log.eventId = 'documentCreatedByCopy' or log.eventId = 'documentRestored')");
            auditQuerySb.append(" or ");
            auditQuerySb.append("log.category = 'eventLifeCycleCategory'");
            auditQuerySb.append(" and log.eventId = 'lifecycle_transition_event' and log.docLifeCycle != 'deleted' ");
            auditQuerySb.append(") and (");
            auditQuerySb.append(this.getCurrentRootFilteringClause(activeRoots.getPaths(), params));
            auditQuerySb.append(") or ");
        }
        auditQuerySb.append("(");
        auditQuerySb.append("log.category = '");
        auditQuerySb.append(NuxeoDriveEvents.EVENT_CATEGORY);
        auditQuerySb.append("' and log.eventId != 'rootUnregistered'");
        auditQuerySb.append(")");
        auditQuerySb.append(") and (");
        auditQuerySb.append(this.getJPADateClause(lastSuccessfulSyncDate, syncDate, params));
        auditQuerySb.append(") order by log.repositoryId asc, log.eventDate desc");
        String auditQuery = auditQuerySb.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Querying audit log: " + auditQuery + " with params: " + params));
        }
        List entries = auditService.nativeQuery(auditQuery, params, 1, limit);
        ArrayList<LogEntry> postFilteredEntries = new ArrayList<LogEntry>();
        String principalName = session.getPrincipal().getName();
        for (LogEntry entry : entries) {
            ExtendedInfo impactedUserInfo = (ExtendedInfo)entry.getExtendedInfos().get("impactedUserName");
            if (impactedUserInfo != null && !principalName.equals(impactedUserInfo.getValue(String.class))) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Change detected at eventDate=%s logDate=%s: %s on %s", entry.getEventDate(), entry.getLogDate(), entry.getEventId(), entry.getDocPath()));
            }
            postFilteredEntries.add(entry);
        }
        return postFilteredEntries;
    }

    protected String getCurrentRootFilteringClause(Set<String> rootPaths, Map<String, Object> params) {
        StringBuilder rootPathClause = new StringBuilder();
        int rootPathCount = 0;
        for (String rootPath : rootPaths) {
            String rootPathParam = "rootPath" + ++rootPathCount;
            if (rootPathClause.length() > 0) {
                rootPathClause.append(" or ");
            }
            rootPathClause.append(String.format("log.docPath like :%s", rootPathParam));
            params.put(rootPathParam, rootPath + '%');
        }
        return rootPathClause.toString();
    }

    protected String getJPADateClause(long lastSuccessfulSyncDate, long syncDate, Map<String, Object> params) {
        params.put("lastSuccessfulSyncDate", new Date(lastSuccessfulSyncDate));
        params.put("syncDate", new Date(syncDate));
        return "log.logDate >= :lastSuccessfulSyncDate and log.logDate < :syncDate";
    }

    protected FileSystemItemChange getFileSystemItemChange(CoreSession session, DocumentRef docRef, LogEntry entry, String expectedFileSystemItemId) throws ClientException {
        DocumentModel doc = session.getDocument(docRef);
        FileSystemItem fsItem = null;
        try {
            fsItem = ((FileSystemItemAdapterService)Framework.getLocalService(FileSystemItemAdapterService.class)).getFileSystemItem(doc);
        }
        catch (RootlessItemException e) {
            log.debug((Object)String.format("RootlessItemException thrown while trying to adapt document %s as a FileSystemItem.", docRef));
        }
        if (fsItem == null) {
            log.debug((Object)String.format("Document %s is not adaptable as a FileSystemItem, returning null.", docRef));
            return null;
        }
        if (expectedFileSystemItemId != null && !expectedFileSystemItemId.equals(fsItem.getId())) {
            log.debug((Object)String.format("Id %s of FileSystemItem adapted from document %s doesn't match expected FileSystemItem id %s, returning null.", fsItem.getId(), docRef, expectedFileSystemItemId));
            return null;
        }
        log.debug((Object)String.format("Document %s is adaptable as a FileSystemItem, providing it to the FileSystemItemChange entry.", docRef));
        return new FileSystemItemChangeImpl(entry.getEventId(), entry.getEventDate().getTime(), entry.getRepositoryId(), entry.getDocUUID(), fsItem);
    }
}

