/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.drive.service.FileSystemChangeFinder;
import org.nuxeo.drive.service.FileSystemChangeSummary;
import org.nuxeo.drive.service.FileSystemItemChange;
import org.nuxeo.drive.service.FileSystemItemManager;
import org.nuxeo.drive.service.NuxeoDriveEvents;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.SynchronizationRoots;
import org.nuxeo.drive.service.TooManyChangesException;
import org.nuxeo.drive.service.impl.AuditChangeFinder;
import org.nuxeo.drive.service.impl.FileSystemChangeSummaryImpl;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.query.nxql.NXQLQueryBuilder;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class NuxeoDriveManagerImpl
extends DefaultComponent
implements NuxeoDriveManager {
    private static final Log log = LogFactory.getLog(NuxeoDriveManagerImpl.class);
    public static final String NUXEO_DRIVE_FACET = "DriveSynchronized";
    public static final String DRIVE_SUBSCRIPTIONS_PROPERTY = "drv:subscriptions";
    public static final String DOCUMENT_CHANGE_LIMIT_PROPERTY = "org.nuxeo.drive.document.change.limit";
    protected Cache<String, Map<String, SynchronizationRoots>> cache;
    protected FileSystemChangeFinder changeFinder = new AuditChangeFinder();

    public NuxeoDriveManagerImpl() {
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(10000L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    }

    protected void clearCache() {
        log.debug((Object)"Invalidating synchronization root cache for all users");
        this.cache.invalidateAll();
    }

    @Override
    public void invalidateSynchronizationRootsCache(String userName) {
        log.debug((Object)("Invalidating synchronization root cache for user: " + userName));
        this.cache.invalidate((Object)userName);
    }

    @Override
    public void registerSynchronizationRoot(Principal principal, DocumentModel newRootContainer, CoreSession session) throws ClientException {
        String userName = principal.getName();
        Map<String, SynchronizationRoots> syncRoots = this.getSynchronizationRoots(principal);
        SynchronizationRoots synchronizationRoots = syncRoots.get(session.getRepositoryName());
        for (String syncRootPath : synchronizationRoots.getPaths()) {
            String parentPathAsString;
            String syncRootPrefixedPath = syncRootPath + "/";
            if (!newRootContainer.getPathAsString().startsWith(syncRootPrefixedPath)) continue;
            boolean rightInheritanceBlockedInTheHierarchy = false;
            Path parentPath = newRootContainer.getPath().removeLastSegments(1);
            while (!"/".equals(parentPath.toString()) && (parentPathAsString = parentPath.toString() + "/").startsWith(syncRootPrefixedPath)) {
                PathRef parentRef = new PathRef(parentPathAsString);
                if (!session.hasPermission(principal, (DocumentRef)parentRef, "Read")) {
                    rightInheritanceBlockedInTheHierarchy = true;
                    break;
                }
                parentPath = parentPath.removeLastSegments(1);
            }
            if (rightInheritanceBlockedInTheHierarchy) continue;
            return;
        }
        this.checkCanUpdateSynchronizationRoot(newRootContainer, session);
        String newRootPrefixedPath = newRootContainer.getPathAsString() + "/";
        for (String existingRootPath : synchronizationRoots.getPaths()) {
            PathRef ref;
            if (!existingRootPath.startsWith(newRootPrefixedPath) || !session.exists((DocumentRef)(ref = new PathRef(existingRootPath)))) continue;
            DocumentModel subFolder = session.getDocument((DocumentRef)ref);
            this.unregisterSynchronizationRoot(principal, subFolder, session);
        }
        if (!newRootContainer.hasFacet(NUXEO_DRIVE_FACET)) {
            newRootContainer.addFacet(NUXEO_DRIVE_FACET);
        }
        this.fireEvent(newRootContainer, session, "aboutToRegisterRoot", userName);
        List subscriptions = (List)((Object)newRootContainer.getPropertyValue(DRIVE_SUBSCRIPTIONS_PROPERTY));
        boolean updated = false;
        for (Map subscription : subscriptions) {
            if (!userName.equals(subscription.get("username"))) continue;
            subscription.put("enabled", Boolean.TRUE);
            subscription.put("lastChangeDate", Calendar.getInstance(TimeZone.getTimeZone("UTC")));
            updated = true;
            break;
        }
        if (!updated) {
            HashMap<String, Object> subscription = new HashMap<String, Object>();
            subscription.put("username", userName);
            subscription.put("enabled", Boolean.TRUE);
            subscription.put("lastChangeDate", Calendar.getInstance(TimeZone.getTimeZone("UTC")));
            subscriptions.add(subscription);
        }
        newRootContainer.setPropertyValue(DRIVE_SUBSCRIPTIONS_PROPERTY, (Serializable)((Object)subscriptions));
        newRootContainer.putContextData("disableAuditLogger", (Serializable)Boolean.valueOf(true));
        newRootContainer.putContextData("disableNotificationService", (Serializable)Boolean.valueOf(true));
        DocumentModel savedNewRootContainer = session.saveDocument(newRootContainer);
        newRootContainer.putContextData("disableAuditLogger", (Serializable)Boolean.valueOf(false));
        newRootContainer.putContextData("disableNotificationService", (Serializable)Boolean.valueOf(false));
        this.fireEvent(savedNewRootContainer, session, "rootRegistered", userName);
        session.save();
        this.invalidateSynchronizationRootsCache(userName);
    }

    @Override
    public void unregisterSynchronizationRoot(Principal principal, DocumentModel rootContainer, CoreSession session) throws ClientException {
        this.checkCanUpdateSynchronizationRoot(rootContainer, session);
        if (!rootContainer.hasFacet(NUXEO_DRIVE_FACET)) {
            rootContainer.addFacet(NUXEO_DRIVE_FACET);
        }
        String userName = principal.getName();
        this.fireEvent(rootContainer, session, "aboutToUnRegisterRoot", userName);
        List subscriptions = (List)((Object)rootContainer.getPropertyValue(DRIVE_SUBSCRIPTIONS_PROPERTY));
        for (Map subscription : subscriptions) {
            if (!userName.equals(subscription.get("username"))) continue;
            subscription.put("enabled", Boolean.FALSE);
            subscription.put("lastChangeDate", Calendar.getInstance(TimeZone.getTimeZone("UTC")));
            break;
        }
        rootContainer.setPropertyValue(DRIVE_SUBSCRIPTIONS_PROPERTY, (Serializable)((Object)subscriptions));
        rootContainer.putContextData("disableAuditLogger", (Serializable)Boolean.valueOf(true));
        rootContainer.putContextData("disableNotificationService", (Serializable)Boolean.valueOf(true));
        session.saveDocument(rootContainer);
        rootContainer.putContextData("disableAuditLogger", (Serializable)Boolean.valueOf(false));
        rootContainer.putContextData("disableNotificationService", (Serializable)Boolean.valueOf(false));
        this.fireEvent(rootContainer, session, "rootUnregistered", userName);
        session.save();
        this.invalidateSynchronizationRootsCache(userName);
    }

    @Override
    public Set<IdRef> getSynchronizationRootReferences(CoreSession session) throws ClientException {
        Map<String, SynchronizationRoots> syncRoots = this.getSynchronizationRoots(session.getPrincipal());
        return syncRoots.get(session.getRepositoryName()).getRefs();
    }

    @Override
    public void handleFolderDeletion(IdRef deleted) throws ClientException {
        this.clearCache();
    }

    protected void fireEvent(DocumentModel sourceDocument, CoreSession session, String eventName, String impactedUserName) throws ClientException {
        EventService eventService = (EventService)Framework.getLocalService(EventService.class);
        DocumentEventContext ctx = new DocumentEventContext(session, session.getPrincipal(), sourceDocument);
        ctx.setProperty("repositoryName", (Serializable)((Object)session.getRepositoryName()));
        ctx.setProperty("sessionId", (Serializable)((Object)session.getSessionId()));
        ctx.setProperty("category", NuxeoDriveEvents.EVENT_CATEGORY);
        ctx.setProperty("impactedUserName", (Serializable)((Object)impactedUserName));
        Event event = ctx.newEvent(eventName);
        eventService.fireEvent(event);
    }

    @Override
    public FileSystemChangeSummary getChangeSummary(Principal principal, Map<String, Set<IdRef>> lastSyncRootRefs, long lastSuccessfulSync) throws ClientException {
        Map<String, SynchronizationRoots> roots = this.getSynchronizationRoots(principal);
        return this.getChangeSummary(principal, lastSyncRootRefs, roots, lastSuccessfulSync);
    }

    protected FileSystemChangeSummary getChangeSummary(Principal principal, Map<String, Set<IdRef>> lastActiveRootRefs, Map<String, SynchronizationRoots> roots, long lastSuccessfulSync) throws ClientException {
        FileSystemItemManager fsManager = (FileSystemItemManager)Framework.getLocalService(FileSystemItemManager.class);
        ArrayList<FileSystemItemChange> allChanges = new ArrayList<FileSystemItemChange>();
        long syncDate = this.changeFinder.getCurrentDate();
        Boolean hasTooManyChanges = Boolean.FALSE;
        int limit = Integer.parseInt(Framework.getProperty((String)DOCUMENT_CHANGE_LIMIT_PROPERTY, (String)"1000"));
        TreeSet<String> allRepositories = new TreeSet<String>();
        allRepositories.addAll(roots.keySet());
        allRepositories.addAll(lastActiveRootRefs.keySet());
        if (!allRepositories.isEmpty() && lastSuccessfulSync > 0L && syncDate > lastSuccessfulSync) {
            for (String repositoryName : allRepositories) {
                try {
                    SynchronizationRoots activeRoots;
                    CoreSession session = fsManager.getSession(repositoryName, principal);
                    Set<Object> lastRefs = lastActiveRootRefs.get(repositoryName);
                    if (lastRefs == null) {
                        lastRefs = Collections.emptySet();
                    }
                    if ((activeRoots = roots.get(repositoryName)) == null) {
                        activeRoots = SynchronizationRoots.getEmptyRoots(repositoryName);
                    }
                    List<FileSystemItemChange> changes = this.changeFinder.getFileSystemChanges(session, lastRefs, activeRoots, lastSuccessfulSync, syncDate, limit);
                    allChanges.addAll(changes);
                }
                catch (TooManyChangesException e) {
                    hasTooManyChanges = Boolean.TRUE;
                    allChanges.clear();
                    break;
                }
            }
        }
        HashMap<String, Set<IdRef>> activeRootRefs = new HashMap<String, Set<IdRef>>();
        for (Map.Entry<String, SynchronizationRoots> rootsEntry : roots.entrySet()) {
            activeRootRefs.put(rootsEntry.getKey(), rootsEntry.getValue().getRefs());
        }
        return new FileSystemChangeSummaryImpl(allChanges, activeRootRefs, syncDate, hasTooManyChanges);
    }

    @Override
    public Map<String, SynchronizationRoots> getSynchronizationRoots(Principal principal) throws ClientException {
        String userName = principal.getName().intern();
        Map<String, SynchronizationRoots> syncRoots = (Map<String, SynchronizationRoots>)this.cache.getIfPresent((Object)userName);
        if (syncRoots == null) {
            syncRoots = this.computeSynchronizationRoots(this.computeSyncRootsQuery(userName), principal);
            this.cache.put((Object)userName, syncRoots);
        }
        return syncRoots;
    }

    @Override
    public boolean isSynchronizationRoot(Principal principal, DocumentModel doc) throws ClientException {
        String repoName = doc.getRepositoryName();
        SynchronizationRoots syncRoots = this.getSynchronizationRoots(principal).get(repoName);
        return syncRoots.getRefs().contains(doc.getRef());
    }

    protected Map<String, SynchronizationRoots> computeSynchronizationRoots(String query, Principal principal) throws ClientException {
        HashMap<String, SynchronizationRoots> syncRoots = new HashMap<String, SynchronizationRoots>();
        FileSystemItemManager fsManager = (FileSystemItemManager)Framework.getLocalService(FileSystemItemManager.class);
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        for (String repositoryName : repositoryManager.getRepositoryNames()) {
            CoreSession session = fsManager.getSession(repositoryName, principal);
            syncRoots.putAll(this.queryAndFecthSynchronizationRoots(session, query));
        }
        return syncRoots;
    }

    protected Map<String, SynchronizationRoots> queryAndFecthSynchronizationRoots(CoreSession session, String query) throws ClientException {
        HashMap<String, SynchronizationRoots> syncRoots = new HashMap<String, SynchronizationRoots>();
        LinkedHashSet<IdRef> references = new LinkedHashSet<IdRef>();
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        IterableQueryResult results = session.queryAndFetch(query, "NXQL", new Object[0]);
        for (Map result : results) {
            IdRef docRef = new IdRef(((Serializable)result.get("ecm:uuid")).toString());
            references.add(docRef);
            paths.add(session.getDocument((DocumentRef)docRef).getPathAsString());
        }
        results.close();
        SynchronizationRoots repoSyncRoots = new SynchronizationRoots(session.getRepositoryName(), paths, references);
        syncRoots.put(session.getRepositoryName(), repoSyncRoots);
        return syncRoots;
    }

    protected void checkCanUpdateSynchronizationRoot(DocumentModel newRootContainer, CoreSession session) throws ClientException {
        if (newRootContainer.isProxy() || newRootContainer.isVersion()) {
            throw new ClientException(String.format("Document '%s' (%s) is not a suitable synchronization root as it is either a readonly proxy or an archived version.", newRootContainer.getTitle(), newRootContainer.getRef()));
        }
        if (!session.hasPermission(newRootContainer.getRef(), "WriteProperties")) {
            throw new ClientException(String.format("Document '%s' (%s) is not a suitable synchronization root for user %s without the WriteProperties permission.", newRootContainer.getTitle(), newRootContainer.getRef(), session.getPrincipal().getName()));
        }
    }

    @Override
    public void setChangeFinder(FileSystemChangeFinder changeFinder) {
        this.changeFinder = changeFinder;
    }

    protected String computeSyncRootsQuery(String username) {
        return String.format("SELECT ecm:uuid FROM Document WHERE %s/*1/username = %s AND %s/*1/enabled = 1 AND ecm:currentLifeCycleState <> 'deleted' ORDER BY dc:title, dc:created DESC", DRIVE_SUBSCRIPTIONS_PROPERTY, NXQLQueryBuilder.prepareStringLiteral((String)username, (boolean)true, (boolean)true), DRIVE_SUBSCRIPTIONS_PROPERTY);
    }
}

