/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.adapter.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.nuxeo.drive.adapter.FileItem;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.impl.AbstractDocumentBackedFileSystemItem;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.runtime.api.Framework;

public class DocumentBackedFolderItem
extends AbstractDocumentBackedFileSystemItem
implements FolderItem {
    private static final long serialVersionUID = 1L;
    private static final String FOLDER_ITEM_CHILDREN_PAGE_PROVIDER = "FOLDER_ITEM_CHILDREN";
    protected boolean canCreateChild;

    public DocumentBackedFolderItem(String factoryName, DocumentModel doc) throws ClientException {
        this(factoryName, doc, false);
    }

    public DocumentBackedFolderItem(String factoryName, DocumentModel doc, boolean relaxSyncRootConstraint) throws ClientException {
        super(factoryName, doc, relaxSyncRootConstraint);
        this.initialize(doc);
    }

    public DocumentBackedFolderItem(String factoryName, FolderItem parentItem, DocumentModel doc) throws ClientException {
        super(factoryName, parentItem, doc);
        this.initialize(doc);
    }

    protected DocumentBackedFolderItem() {
    }

    @Override
    public void rename(String name) throws ClientException {
        CoreSession session = this.getSession();
        DocumentModel doc = this.getDocument(session);
        doc.setPropertyValue("dc:title", (Serializable)((Object)name));
        doc = session.saveDocument(doc);
        session.save();
        this.docTitle = name;
        this.name = name;
        this.updateLastModificationDate(doc);
    }

    @Override
    public List<FileSystemItem> getChildren() throws ClientException {
        PageProviderService pageProviderService = (PageProviderService)Framework.getLocalService(PageProviderService.class);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.getSession());
        PageProvider childrenPageProvider = pageProviderService.getPageProvider(FOLDER_ITEM_CHILDREN_PAGE_PROVIDER, null, null, Long.valueOf(0L), props, new Object[]{this.docId});
        List dmChildren = childrenPageProvider.getCurrentPage();
        ArrayList<FileSystemItem> children = new ArrayList<FileSystemItem>(dmChildren.size());
        for (DocumentModel dmChild : dmChildren) {
            FileSystemItem child = this.getFileSystemItemAdapterService().getFileSystemItem(dmChild, this);
            if (child == null) continue;
            children.add(child);
        }
        return children;
    }

    @Override
    public boolean getCanCreateChild() {
        return this.canCreateChild;
    }

    @Override
    public FolderItem createFolder(String name) throws ClientException {
        try {
            DocumentModel folder = this.getFileManager().createFolder(this.getSession(), name, this.docPath);
            if (folder == null) {
                throw new ClientException(String.format("Cannot create folder named '%s' as a child of doc %s. Probably because of the allowed sub-types for this doc type, please check them.", name, this.docPath));
            }
            return (FolderItem)this.getFileSystemItemAdapterService().getFileSystemItem(folder, this);
        }
        catch (Exception e) {
            throw new ClientException(String.format("Error while trying to create folder %s as a child of doc %s", name, this.docPath), (Throwable)e);
        }
    }

    @Override
    public FileItem createFile(Blob blob) throws ClientException {
        String fileName = blob.getFilename();
        try {
            DocumentModel file = this.getFileManager().createDocumentFromBlob(this.getSession(), blob, this.docPath, true, fileName);
            if (file == null) {
                throw new ClientException(String.format("Cannot create file '%s' as a child of doc %s. Probably because there are no file importers registered, please check the contributions to the <extension target=\"org.nuxeo.ecm.platform.filemanager.service.FileManagerService\" point=\"plugins\"> extension point.", fileName, this.docPath));
            }
            return (FileItem)this.getFileSystemItemAdapterService().getFileSystemItem(file, this);
        }
        catch (Exception e) {
            throw new ClientException(String.format("Error while trying to create file %s as a child of doc %s", fileName, this.docPath), (Throwable)e);
        }
    }

    protected void initialize(DocumentModel doc) throws ClientException {
        this.name = this.docTitle;
        this.folder = true;
        this.canCreateChild = doc.getCoreSession().hasPermission(doc.getRef(), "AddChildren");
    }

    protected FileManager getFileManager() {
        return (FileManager)Framework.getLocalService(FileManager.class);
    }

    protected void setCanCreateChild(boolean canCreateChild) {
        this.canCreateChild = canCreateChild;
    }
}

