/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.hierarchy.userworkspace.adapter;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.impl.DocumentBackedFolderItem;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.VirtualFolderItemFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.api.Framework;

public class UserWorkspaceTopLevelFolderItem
extends DocumentBackedFolderItem {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(UserWorkspaceTopLevelFolderItem.class);
    protected DocumentModel userWorkspace;
    protected String syncRootParentFactoryName;

    public UserWorkspaceTopLevelFolderItem(String factoryName, DocumentModel userWorkspace, String folderName, String syncRootParentFactoryName) throws ClientException {
        this(factoryName, userWorkspace, folderName, syncRootParentFactoryName, false);
    }

    public UserWorkspaceTopLevelFolderItem(String factoryName, DocumentModel userWorkspace, String folderName, String syncRootParentFactoryName, boolean relaxSyncRootConstraint) throws ClientException {
        super(factoryName, null, userWorkspace, relaxSyncRootConstraint);
        this.name = folderName;
        this.canRename = false;
        this.canDelete = false;
        this.userWorkspace = userWorkspace;
        this.syncRootParentFactoryName = syncRootParentFactoryName;
    }

    protected UserWorkspaceTopLevelFolderItem() {
    }

    @Override
    public void rename(String name) throws ClientException {
        throw new UnsupportedOperationException("Cannot rename the top level folder item.");
    }

    @Override
    public void delete() throws ClientException {
        throw new UnsupportedOperationException("Cannot delete the top level folder item.");
    }

    @Override
    public FileSystemItem move(FolderItem dest) throws ClientException {
        throw new UnsupportedOperationException("Cannot move the top level folder item.");
    }

    @Override
    public List<FileSystemItem> getChildren() throws ClientException {
        if (!this.getNuxeoDriveManager().isSynchronizationRoot(this.principal, this.userWorkspace)) {
            this.getNuxeoDriveManager().registerSynchronizationRoot(this.principal, this.userWorkspace, this.getSession());
        }
        ArrayList<FileSystemItem> children = new ArrayList<FileSystemItem>();
        children.addAll(super.getChildren());
        if (this.syncRootParentFactoryName == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("No synchronization root parent factory name parameter for factory %s, the synchronization roots won't be synchronized client side.", this.factoryName));
            }
        } else {
            VirtualFolderItemFactory syncRootParentFactory = this.getFileSystemItemAdapterService().getVirtualFolderItemFactory(this.syncRootParentFactoryName);
            FolderItem syncRootParent = syncRootParentFactory.getVirtualFolderItem(this.principal);
            if (syncRootParent != null) {
                children.add(syncRootParent);
            }
        }
        return children;
    }

    protected NuxeoDriveManager getNuxeoDriveManager() {
        return (NuxeoDriveManager)Framework.getLocalService(NuxeoDriveManager.class);
    }
}

