/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.hierarchy.permission.factory;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.hierarchy.permission.adapter.PermissionTopLevelFolderItem;
import org.nuxeo.drive.service.TopLevelFolderItemFactory;
import org.nuxeo.drive.service.impl.AbstractVirtualFolderItemFactory;
import org.nuxeo.ecm.core.api.ClientException;

public class PermissionTopLevelFactory
extends AbstractVirtualFolderItemFactory
implements TopLevelFolderItemFactory {
    private static final Log log = LogFactory.getLog(PermissionTopLevelFactory.class);
    protected static final String CHILDREN_FACTORIES_PARAM = "childrenFactories";
    protected List<String> childrenFactoryNames = new ArrayList<String>();

    @Override
    public void handleParameters(Map<String, String> parameters) throws ClientException {
        super.handleParameters(parameters);
        String childrenFactoriesParam = parameters.get(CHILDREN_FACTORIES_PARAM);
        if (!StringUtils.isEmpty((String)childrenFactoriesParam)) {
            this.childrenFactoryNames.addAll(Arrays.asList(childrenFactoriesParam.split(",")));
        } else {
            log.warn((Object)String.format("Factory %s has no %s parameter, please provide one in the factory contribution using a comma separated list to set the children factory names.", this.getName(), CHILDREN_FACTORIES_PARAM));
        }
    }

    @Override
    public FolderItem getVirtualFolderItem(Principal principal) throws ClientException {
        return this.getTopLevelFolderItem(principal);
    }

    @Override
    public FolderItem getTopLevelFolderItem(Principal principal) throws ClientException {
        return new PermissionTopLevelFolderItem(this.getName(), principal, this.getFolderName(), this.childrenFactoryNames);
    }
}

