/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.adapter.impl;

import java.security.Principal;
import java.util.Calendar;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.drive.service.FileSystemItemManager;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractFileSystemItem
implements FileSystemItem {
    public static final String FILE_SYSTEM_ITEM_ID_SEPARATOR = "#";
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String parentId;
    protected String name;
    protected boolean folder;
    protected String creator;
    protected String lastContributor;
    protected Calendar creationDate;
    protected Calendar lastModificationDate;
    protected boolean canRename;
    protected boolean canDelete;
    protected String factoryName;
    protected String path;
    protected transient Principal principal;
    protected String userName;

    protected AbstractFileSystemItem(String factoryName, Principal principal, boolean relaxSyncRootConstraint) {
        this.factoryName = factoryName;
        this.principal = principal;
        this.userName = principal.getName();
        this.id = relaxSyncRootConstraint ? "" : this.factoryName + FILE_SYSTEM_ITEM_ID_SEPARATOR;
    }

    protected AbstractFileSystemItem() {
    }

    @Override
    public abstract void rename(String var1) throws ClientException;

    @Override
    public abstract void delete() throws ClientException;

    @Override
    public abstract boolean canMove(FolderItem var1) throws ClientException;

    @Override
    public abstract FileSystemItem move(FolderItem var1) throws ClientException;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isFolder() {
        return this.folder;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public String getLastContributor() {
        return this.lastContributor;
    }

    @Override
    public Calendar getCreationDate() {
        return this.creationDate;
    }

    @Override
    public Calendar getLastModificationDate() {
        return this.lastModificationDate;
    }

    @Override
    public boolean getCanRename() {
        return this.canRename;
    }

    @Override
    public boolean getCanDelete() {
        return this.canDelete;
    }

    public String getUserName() {
        return this.userName;
    }

    @Override
    public int compareTo(FileSystemItem other) {
        if (StringUtils.isEmpty((String)this.getName()) && StringUtils.isEmpty((String)other.getName())) {
            return 0;
        }
        if (StringUtils.isEmpty((String)this.getName()) && !StringUtils.isEmpty((String)other.getName())) {
            return -1;
        }
        if (!StringUtils.isEmpty((String)this.getName()) && StringUtils.isEmpty((String)other.getName())) {
            return 1;
        }
        return this.getName().compareTo(other.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FileSystemItem)) {
            return false;
        }
        return this.getId().equals(((FileSystemItem)obj).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return String.format("%s(id=\"%s\", name=\"%s\")", this.getClass().getSimpleName(), this.getId(), this.getName());
    }

    protected CoreSession getSession(String repositoryName) throws ClientException {
        return this.getFileSystemItemManager().getSession(repositoryName, this.principal);
    }

    protected FileSystemItemManager getFileSystemItemManager() {
        return (FileSystemItemManager)Framework.getLocalService(FileSystemItemManager.class);
    }

    protected FileSystemItemAdapterService getFileSystemItemAdapterService() {
        return (FileSystemItemAdapterService)Framework.getLocalService(FileSystemItemAdapterService.class);
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setPath(String path) {
        this.path = path;
    }

    protected void setParentId(String parentId) {
        this.parentId = parentId;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setFolder(boolean isFolder) {
        this.folder = isFolder;
    }

    protected void setCreator(String creator) {
        this.creator = creator;
    }

    protected void setLastContributor(String lastContributor) {
        this.lastContributor = lastContributor;
    }

    protected void setCreationDate(Calendar creationDate) {
        this.creationDate = creationDate;
    }

    protected void setLastModificationDate(Calendar lastModificationDate) {
        this.lastModificationDate = lastModificationDate;
    }

    protected void setCanRename(boolean canRename) {
        this.canRename = canRename;
    }

    protected void setCanDelete(boolean canDelete) {
        this.canDelete = canDelete;
    }

    protected void setUserName(String userName) throws ClientException {
        this.userName = userName;
        this.principal = ((UserManager)Framework.getLocalService(UserManager.class)).getPrincipal(userName);
    }
}

