/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.servlet.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.wss.servlet.config.FilterBindingConfig;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlConfigHandler
extends DefaultHandler {
    protected List<FilterBindingConfig> configEntries = null;
    protected FilterBindingConfig currentConfig = null;
    public static final String FILTERMAPPING_TAG = "filtermapping";
    public static final String URL_ATTRIBUTE = "url";
    public static final String REDIRECT_ATTRIBUTE = "redirect";
    public static final String SERVICE_ATTRIBUTE = "service";
    public static final String TYPE_ATTRIBUTE = "type";
    protected static String configName = "wssdefaultbindings-config.xml";
    protected static XmlConfigHandler instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (FILTERMAPPING_TAG.equalsIgnoreCase(name)) {
            XmlConfigHandler xmlConfigHandler = this;
            synchronized (xmlConfigHandler) {
                this.currentConfig = new FilterBindingConfig();
                if (attributes != null) {
                    this.currentConfig.setUrl(this.getAttributeValue(attributes, URL_ATTRIBUTE));
                    this.currentConfig.setRedirectURL(this.getAttributeValue(attributes, REDIRECT_ATTRIBUTE));
                    this.currentConfig.setTargetService(this.getAttributeValue(attributes, SERVICE_ATTRIBUTE));
                    this.currentConfig.setRequestType(this.getAttributeValue(attributes, TYPE_ATTRIBUTE));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (FILTERMAPPING_TAG.equalsIgnoreCase(name)) {
            XmlConfigHandler xmlConfigHandler = this;
            synchronized (xmlConfigHandler) {
                if (this.configEntries == null) {
                    this.configEntries = new ArrayList<FilterBindingConfig>();
                }
                this.configEntries.add(this.currentConfig);
                this.currentConfig = null;
            }
        }
    }

    private String getAttributeValue(Attributes attributes, String key) {
        try {
            return attributes.getValue(key);
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    public static String getConfigName() {
        return configName;
    }

    public static void setConfigName(String configName) {
        XmlConfigHandler.configName = configName;
    }

    public static void loadConfig() throws IOException {
        XmlConfigHandler.loadConfig(XmlConfigHandler.getConfigName());
    }

    protected static XmlConfigHandler getInstance() {
        if (instance == null) {
            instance = new XmlConfigHandler();
        }
        return instance;
    }

    public static void loadConfig(String configName) throws IOException {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(configName);
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(XmlConfigHandler.getInstance());
            reader.setFeature("http://xml.org/sax/features/namespaces", false);
            reader.setFeature("http://xml.org/sax/features/validation", false);
            reader.parse(new InputSource(in));
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    public static List<FilterBindingConfig> getConfigEntries() throws IOException {
        List<FilterBindingConfig> entries = XmlConfigHandler.getInstance().getParsedConfigEntries();
        if (entries == null) {
            XmlConfigHandler.loadConfig();
            entries = XmlConfigHandler.getInstance().getParsedConfigEntries();
        }
        return entries;
    }

    protected List<FilterBindingConfig> getParsedConfigEntries() {
        return this.configEntries;
    }
}

