/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.adapter.impl;

import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.nuxeo.drive.adapter.FileItem;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.impl.AbstractDocumentBackedFileSystemItem;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.runtime.api.Framework;

public class DocumentBackedFolderItem
extends AbstractDocumentBackedFileSystemItem
implements FolderItem {
    private static final long serialVersionUID = 1L;
    private static final String FOLDER_ITEM_CHILDREN_PAGE_PROVIDER = "FOLDER_ITEM_CHILDREN";
    protected boolean canCreateChild;

    public DocumentBackedFolderItem(String factoryName, DocumentModel doc) {
        this(factoryName, doc, false);
    }

    public DocumentBackedFolderItem(String factoryName, DocumentModel doc, boolean relaxSyncRootConstraint) {
        super(factoryName, doc, relaxSyncRootConstraint);
        this.initialize(doc);
    }

    public DocumentBackedFolderItem(String factoryName, FolderItem parentItem, DocumentModel doc) {
        this(factoryName, parentItem, doc, false);
    }

    public DocumentBackedFolderItem(String factoryName, FolderItem parentItem, DocumentModel doc, boolean relaxSyncRootConstraint) {
        super(factoryName, parentItem, doc, relaxSyncRootConstraint);
        this.initialize(doc);
    }

    protected DocumentBackedFolderItem() {
    }

    @Override
    public void rename(String name) {
        try (CoreSession session = CoreInstance.openCoreSession((String)this.repositoryName, (Principal)this.principal);){
            DocumentModel doc = this.getDocument(session);
            doc.setPropertyValue("dc:title", (Serializable)((Object)name));
            doc = session.saveDocument(doc);
            session.save();
            this.docTitle = name;
            this.name = name;
            this.updateLastModificationDate(doc);
        }
    }

    @Override
    public List<FileSystemItem> getChildren() {
        try (CoreSession session = CoreInstance.openCoreSession((String)this.repositoryName, (Principal)this.principal);){
            PageProviderService pageProviderService = (PageProviderService)Framework.getLocalService(PageProviderService.class);
            HashMap<String, Serializable> props = new HashMap<String, Serializable>();
            props.put("coreSession", (Serializable)session);
            PageProvider childrenPageProvider = pageProviderService.getPageProvider(FOLDER_ITEM_CHILDREN_PAGE_PROVIDER, null, null, Long.valueOf(0L), props, new Object[]{this.docId});
            Long pageSize = childrenPageProvider.getPageSize();
            ArrayList<FileSystemItem> children = new ArrayList<FileSystemItem>();
            int nbChildren = 0;
            boolean reachedPageSize = false;
            boolean hasNextPage = true;
            while ((long)nbChildren < pageSize && hasNextPage) {
                List dmChildren = childrenPageProvider.getCurrentPage();
                for (DocumentModel dmChild : dmChildren) {
                    FileSystemItem child = this.getFileSystemItemAdapterService().getFileSystemItem(dmChild, this);
                    if (child == null) continue;
                    children.add(child);
                    if ((long)(++nbChildren) != pageSize) continue;
                    reachedPageSize = true;
                    break;
                }
                if (reachedPageSize || !(hasNextPage = childrenPageProvider.isNextPageAvailable())) continue;
                childrenPageProvider.nextPage();
            }
            ArrayList<FileSystemItem> arrayList = children;
            return arrayList;
        }
    }

    @Override
    public boolean getCanCreateChild() {
        return this.canCreateChild;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FolderItem createFolder(String name) {
        try (CoreSession session = CoreInstance.openCoreSession((String)this.repositoryName, (Principal)this.principal);){
            DocumentModel folder = this.getFileManager().createFolder(session, name, this.docPath);
            if (folder == null) {
                throw new NuxeoException(String.format("Cannot create folder named '%s' as a child of doc %s. Probably because of the allowed sub-types for this doc type, please check them.", name, this.docPath));
            }
            FolderItem folderItem = (FolderItem)this.getFileSystemItemAdapterService().getFileSystemItem(folder, this);
            return folderItem;
        }
        catch (NuxeoException e) {
            e.addInfo(String.format("Error while trying to create folder %s as a child of doc %s", name, this.docPath));
            throw e;
        }
        catch (IOException e) {
            throw new NuxeoException(String.format("Error while trying to create folder %s as a child of doc %s", name, this.docPath), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileItem createFile(Blob blob) {
        String fileName = blob.getFilename();
        try (CoreSession session = CoreInstance.openCoreSession((String)this.repositoryName, (Principal)this.principal);){
            DocumentModel file = this.getFileManager().createDocumentFromBlob(session, blob, this.docPath, true, fileName);
            if (file == null) {
                throw new NuxeoException(String.format("Cannot create file '%s' as a child of doc %s. Probably because there are no file importers registered, please check the contributions to the <extension target=\"org.nuxeo.ecm.platform.filemanager.service.FileManagerService\" point=\"plugins\"> extension point.", fileName, this.docPath));
            }
            FileItem fileItem = (FileItem)this.getFileSystemItemAdapterService().getFileSystemItem(file, this);
            return fileItem;
        }
        catch (NuxeoException e) {
            e.addInfo(String.format("Error while trying to create file %s as a child of doc %s", fileName, this.docPath));
            throw e;
        }
        catch (IOException e) {
            throw new NuxeoException(String.format("Error while trying to create file %s as a child of doc %s", fileName, this.docPath), (Throwable)e);
        }
    }

    protected void initialize(DocumentModel doc) {
        this.name = this.docTitle;
        this.folder = true;
        this.canCreateChild = !doc.hasFacet("PublishSpace") && doc.getCoreSession().hasPermission(doc.getRef(), "AddChildren");
    }

    protected FileManager getFileManager() {
        return (FileManager)Framework.getLocalService(FileManager.class);
    }

    protected void setCanCreateChild(boolean canCreateChild) {
        this.canCreateChild = canCreateChild;
    }
}

