/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations;

import org.nuxeo.drive.service.FileSystemItemManager;
import org.nuxeo.ecm.automation.InvalidOperationException;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.runtime.api.Framework;

@Operation(id="NuxeoDrive.Delete", category="Services", label="Nuxeo Drive: Delete")
public class NuxeoDriveDelete {
    public static final String ID = "NuxeoDrive.Delete";
    @Context
    protected OperationContext ctx;
    @Param(name="id")
    protected String id;
    @Param(name="parentId", required=false)
    protected String parentId;

    @OperationMethod
    public void run() throws ClientException, InvalidOperationException {
        FileSystemItemManager fileSystemItemManager = (FileSystemItemManager)Framework.getLocalService(FileSystemItemManager.class);
        try {
            if (this.parentId == null) {
                fileSystemItemManager.delete(this.id, this.ctx.getPrincipal());
            } else {
                fileSystemItemManager.delete(this.id, this.parentId, this.ctx.getPrincipal());
            }
        }
        catch (UnsupportedOperationException e) {
            throw new InvalidOperationException((Throwable)e);
        }
    }
}

