/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.hierarchy.userworkspace.factory;

import java.security.Principal;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.hierarchy.userworkspace.adapter.UserWorkspaceHelper;
import org.nuxeo.drive.hierarchy.userworkspace.adapter.UserWorkspaceTopLevelFolderItem;
import org.nuxeo.drive.service.TopLevelFolderItemFactory;
import org.nuxeo.drive.service.impl.AbstractFileSystemItemFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.runtime.api.Framework;

public class UserWorkspaceTopLevelFactory
extends AbstractFileSystemItemFactory
implements TopLevelFolderItemFactory {
    private static final Log log = LogFactory.getLog(UserWorkspaceTopLevelFactory.class);
    protected static final String FOLDER_NAME_PARAM = "folderName";
    protected static final String SYNC_ROOT_PARENT_FACTORY_PARAM = "syncRootParentFactory";
    protected static final String DEFAULT_FOLDER_NAME = "Nuxeo Drive";
    protected String folderName = "Nuxeo Drive";
    protected String syncRootParentFactoryName;

    @Override
    public void handleParameters(Map<String, String> parameters) throws ClientException {
        String folderNameParam = parameters.get(FOLDER_NAME_PARAM);
        if (!StringUtils.isEmpty((String)folderNameParam)) {
            this.folderName = folderNameParam;
        } else {
            log.info((Object)String.format("Factory %s has no %s parameter, you can provide one in the factory contribution to avoid using the default value '%s'.", this.getName(), FOLDER_NAME_PARAM, DEFAULT_FOLDER_NAME));
        }
        String syncRootParentFactoryParam = parameters.get(SYNC_ROOT_PARENT_FACTORY_PARAM);
        if (!StringUtils.isEmpty((String)syncRootParentFactoryParam)) {
            this.syncRootParentFactoryName = syncRootParentFactoryParam;
        } else {
            log.warn((Object)String.format("Factory %s has no %s parameter, please provide one in the factory contribution to set the name of the synchronization root parent factory.", this.getName(), SYNC_ROOT_PARENT_FACTORY_PARAM));
        }
    }

    @Override
    public boolean isFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint) throws ClientException {
        boolean isUserWorkspace = UserWorkspaceHelper.isUserWorkspace(doc);
        if (!isUserWorkspace) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Document %s is not a user workspace, it cannot be adapted as a FileSystemItem.", doc.getId()));
            }
            return false;
        }
        return true;
    }

    @Override
    protected FileSystemItem adaptDocument(DocumentModel doc, boolean forceParentItem, FolderItem parentItem, boolean relaxSyncRootConstraint) throws ClientException {
        return new UserWorkspaceTopLevelFolderItem(this.getName(), doc, this.folderName, this.syncRootParentFactoryName, relaxSyncRootConstraint);
    }

    @Override
    public FolderItem getVirtualFolderItem(Principal principal) throws ClientException {
        return this.getTopLevelFolderItem(principal);
    }

    @Override
    public String getFolderName() {
        return this.folderName;
    }

    @Override
    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    @Override
    public FolderItem getTopLevelFolderItem(Principal principal) throws ClientException {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        try (CoreSession session = CoreInstance.openCoreSession((String)repositoryManager.getDefaultRepositoryName(), (Principal)principal);){
            UserWorkspaceService userWorkspaceService = (UserWorkspaceService)Framework.getLocalService(UserWorkspaceService.class);
            DocumentModel userWorkspace = userWorkspaceService.getCurrentUserPersonalWorkspace(session, null);
            if (userWorkspace == null) {
                throw new ClientException(String.format("No personal workspace found for user %s.", principal.getName()));
            }
            FolderItem folderItem = (FolderItem)this.getFileSystemItem(userWorkspace);
            return folderItem;
        }
    }
}

