/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.elasticsearch;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.AndFilterBuilder;
import org.elasticsearch.index.query.BoolFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.OrFilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeFilterBuilder;
import org.elasticsearch.index.query.TermFilterBuilder;
import org.elasticsearch.index.query.TermsFilterBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortOrder;
import org.nuxeo.drive.service.SynchronizationRoots;
import org.nuxeo.drive.service.impl.AuditChangeFinder;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.audit.io.AuditEntryJSONReader;
import org.nuxeo.runtime.api.Framework;

public class ESAuditChangeFinder
extends AuditChangeFinder {
    private static final long serialVersionUID = 1L;
    public static final Log log = LogFactory.getLog(ESAuditChangeFinder.class);
    protected Client esClient = null;

    protected List<LogEntry> queryESAuditEntries(CoreSession session, SynchronizationRoots activeRoots, Set<String> collectionSyncRootMemberIds, long lowerBound, long upperBound, boolean integerBounds, int limit) {
        SearchRequestBuilder builder = this.getClient().prepareSearch(new String[]{"audit"}).setTypes(new String[]{"entry"}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH);
        MatchAllQueryBuilder queryBuilder = QueryBuilders.matchAllQuery();
        FilterBuilder filterBuilder = this.buildFilterClauses(session, activeRoots, collectionSyncRootMemberIds, lowerBound, upperBound, integerBounds, limit);
        builder.setQuery((QueryBuilder)QueryBuilders.filteredQuery((QueryBuilder)queryBuilder, (FilterBuilder)filterBuilder));
        builder.addSort("repositoryId", SortOrder.ASC);
        builder.addSort("eventDate", SortOrder.DESC);
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        SearchResponse searchResponse = (SearchResponse)builder.setFrom(0).setSize(limit).execute().actionGet();
        for (SearchHit hit : searchResponse.getHits()) {
            try {
                entries.add(AuditEntryJSONReader.read((String)hit.getSourceAsString()));
            }
            catch (Exception e) {
                log.error((Object)"Error while reading Audit Entry from ES", (Throwable)e);
            }
        }
        return entries;
    }

    protected FilterBuilder buildFilterClauses(CoreSession session, SynchronizationRoots activeRoots, Set<String> collectionSyncRootMemberIds, long lowerBound, long upperBound, boolean integerBounds, int limit) {
        AndFilterBuilder filterBuilder = FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[0]);
        TermFilterBuilder repositoryClauseFilter = FilterBuilders.termFilter((String)"repositoryId", (String)session.getRepositoryName());
        filterBuilder.add((FilterBuilder)repositoryClauseFilter);
        if (activeRoots.getPaths().isEmpty()) {
            filterBuilder.add((FilterBuilder)this.getDriveLogsQueryClause());
        } else {
            OrFilterBuilder orFilterBuilderIfActiveRoots = FilterBuilders.orFilter((FilterBuilder[])new FilterBuilder[0]);
            String[] eventIds = new String[]{"documentCreated", "documentModified", "documentMoved", "documentCreatedByCopy", "documentRestored", "addedToCollection"};
            OrFilterBuilder orEventsFilter = FilterBuilders.orFilter((FilterBuilder[])new FilterBuilder[0]);
            orEventsFilter.add((FilterBuilder)this.getEventsClause("eventDocumentCategory", eventIds, true));
            orEventsFilter.add((FilterBuilder)this.getEventsClause("eventLifeCycleCategory", new String[]{"lifecycle_transition_event"}, true));
            orEventsFilter.add((FilterBuilder)this.getEventsClause("eventLifeCycleCategory", new String[]{"deleted"}, false));
            if (collectionSyncRootMemberIds != null && collectionSyncRootMemberIds.size() > 0) {
                OrFilterBuilder rootsOrCollectionsFilter = FilterBuilders.orFilter((FilterBuilder[])new FilterBuilder[0]);
                rootsOrCollectionsFilter.add((FilterBuilder)this.getCurrentRootsClause(activeRoots.getPaths()));
                rootsOrCollectionsFilter.add((FilterBuilder)this.getCollectionSyncRootClause(collectionSyncRootMemberIds));
                orFilterBuilderIfActiveRoots.add((FilterBuilder)FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{orEventsFilter, rootsOrCollectionsFilter}));
            } else {
                orFilterBuilderIfActiveRoots.add((FilterBuilder)FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{orEventsFilter, this.getCurrentRootsClause(activeRoots.getPaths())}));
            }
            orFilterBuilderIfActiveRoots.add((FilterBuilder)this.getDriveLogsQueryClause());
            filterBuilder.add((FilterBuilder)orFilterBuilderIfActiveRoots);
        }
        filterBuilder.add((FilterBuilder)this.getLogIdBoundsClause(lowerBound, upperBound));
        return filterBuilder;
    }

    protected RangeFilterBuilder getLogIdBoundsClause(long lowerBound, long upperBound) {
        RangeFilterBuilder rangeFilter = FilterBuilders.rangeFilter((String)"id");
        rangeFilter.gt(lowerBound);
        rangeFilter.lte(upperBound);
        return rangeFilter;
    }

    protected TermsFilterBuilder getCollectionSyncRootClause(Set<String> collectionSyncRootMemberIds) {
        return FilterBuilders.termsFilter((String)"docUUID", collectionSyncRootMemberIds);
    }

    protected OrFilterBuilder getCurrentRootsClause(Set<String> rootPaths) {
        OrFilterBuilder orFilterRoots = FilterBuilders.orFilter((FilterBuilder[])new FilterBuilder[0]);
        for (String rootPath : rootPaths) {
            orFilterRoots.add((FilterBuilder)FilterBuilders.prefixFilter((String)"docPath", (String)rootPath));
        }
        return orFilterRoots;
    }

    protected BoolFilterBuilder getDriveLogsQueryClause() {
        BoolFilterBuilder filterBuilder = FilterBuilders.boolFilter();
        filterBuilder.must((FilterBuilder)FilterBuilders.termFilter((String)"category", (String)"NuxeoDrive"));
        filterBuilder.mustNot((FilterBuilder)FilterBuilders.termFilter((String)"eventId", (String)"rootUnregistered"));
        return filterBuilder;
    }

    protected BoolFilterBuilder getEventsClause(String category, String[] eventIds, boolean shouldMatch) {
        BoolFilterBuilder filterBuilder = FilterBuilders.boolFilter();
        filterBuilder.must((FilterBuilder)FilterBuilders.termFilter((String)"category", (String)category));
        if (eventIds != null && eventIds.length > 0) {
            if (eventIds.length == 1) {
                if (shouldMatch) {
                    filterBuilder.must((FilterBuilder)FilterBuilders.termFilter((String)"eventId", (String)eventIds[0]));
                } else {
                    filterBuilder.mustNot((FilterBuilder)FilterBuilders.termFilter((String)"eventId", (String)eventIds[0]));
                }
            } else if (shouldMatch) {
                filterBuilder.must((FilterBuilder)FilterBuilders.termsFilter((String)"eventId", (String[])eventIds));
            } else {
                filterBuilder.mustNot((FilterBuilder)FilterBuilders.termsFilter((String)"eventId", (String[])eventIds));
            }
        }
        return filterBuilder;
    }

    public long getUpperBound() {
        SearchRequestBuilder builder = this.getClient().prepareSearch(new String[]{"audit"}).setTypes(new String[]{"entry"}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH);
        builder.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
        builder.addSort("id", SortOrder.DESC);
        builder.setFrom(0);
        builder.setSize(1);
        SearchResponse searchResponse = (SearchResponse)builder.execute().actionGet();
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        SearchHits hits = searchResponse.getHits();
        for (SearchHit hit : hits) {
            try {
                entries.add(AuditEntryJSONReader.read((String)hit.getSourceAsString()));
            }
            catch (Exception e) {
                log.error((Object)"Error while reading Audit Entry from ES", (Throwable)e);
            }
        }
        return entries.size() > 0 ? ((LogEntry)entries.get(0)).getId() : -1L;
    }

    protected List<LogEntry> queryAuditEntries(CoreSession session, SynchronizationRoots activeRoots, Set<String> collectionSyncRootMemberIds, long lowerBound, long upperBound, boolean integerBounds, int limit) {
        List<LogEntry> entries = this.queryESAuditEntries(session, activeRoots, collectionSyncRootMemberIds, lowerBound, upperBound, integerBounds, limit);
        ArrayList<LogEntry> postFilteredEntries = new ArrayList<LogEntry>();
        String principalName = session.getPrincipal().getName();
        for (LogEntry entry : entries) {
            ExtendedInfo impactedUserInfo = (ExtendedInfo)entry.getExtendedInfos().get("impactedUserName");
            if (impactedUserInfo != null && !principalName.equals(impactedUserInfo.getValue(String.class))) continue;
            if (log.isDebugEnabled() && log.isDebugEnabled()) {
                log.debug((Object)String.format("Change with eventId=%d detected at eventDate=%s, logDate=%s: %s on %s", entry.getId(), entry.getEventDate(), entry.getLogDate(), entry.getEventId(), entry.getDocPath()));
            }
            postFilteredEntries.add(entry);
        }
        return postFilteredEntries;
    }

    protected Client getClient() {
        if (this.esClient == null) {
            log.info((Object)"Activate Elasticsearch backend for Audit");
            ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
            this.esClient = esa.getClient();
        }
        return this.esClient;
    }
}

