/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.NuxeoDriveContribException;
import org.nuxeo.drive.adapter.RootlessItemException;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.drive.service.FileSystemItemFactory;
import org.nuxeo.drive.service.TopLevelFolderItemFactory;
import org.nuxeo.drive.service.VirtualFolderItemFactory;
import org.nuxeo.drive.service.impl.ActiveFileSystemItemFactoriesDescriptor;
import org.nuxeo.drive.service.impl.ActiveFileSystemItemFactoryRegistry;
import org.nuxeo.drive.service.impl.ActiveTopLevelFolderItemFactoryDescriptor;
import org.nuxeo.drive.service.impl.ActiveTopLevelFolderItemFactoryRegistry;
import org.nuxeo.drive.service.impl.FileSystemItemFactoryDescriptor;
import org.nuxeo.drive.service.impl.FileSystemItemFactoryRegistry;
import org.nuxeo.drive.service.impl.FileSystemItemFactoryWrapper;
import org.nuxeo.drive.service.impl.TopLevelFolderItemFactoryDescriptor;
import org.nuxeo.drive.service.impl.TopLevelFolderItemFactoryRegistry;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class FileSystemItemAdapterServiceImpl
extends DefaultComponent
implements FileSystemItemAdapterService {
    private static final Log log = LogFactory.getLog(FileSystemItemAdapterServiceImpl.class);
    public static final String FILE_SYSTEM_ITEM_FACTORY_EP = "fileSystemItemFactory";
    public static final String TOP_LEVEL_FOLDER_ITEM_FACTORY_EP = "topLevelFolderItemFactory";
    public static final String ACTIVE_FILE_SYSTEM_ITEM_FACTORIES_EP = "activeFileSystemItemFactories";
    protected TopLevelFolderItemFactoryRegistry topLevelFolderItemFactoryRegistry;
    protected FileSystemItemFactoryRegistry fileSystemItemFactoryRegistry;
    protected ActiveTopLevelFolderItemFactoryRegistry activeTopLevelFolderItemFactoryRegistry;
    protected ActiveFileSystemItemFactoryRegistry activeFileSystemItemFactoryRegistry;
    protected TopLevelFolderItemFactory topLevelFolderItemFactory;
    protected List<FileSystemItemFactoryWrapper> fileSystemItemFactories;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (FILE_SYSTEM_ITEM_FACTORY_EP.equals(extensionPoint)) {
            this.fileSystemItemFactoryRegistry.addContribution((FileSystemItemFactoryDescriptor)contribution);
        } else if (TOP_LEVEL_FOLDER_ITEM_FACTORY_EP.equals(extensionPoint)) {
            this.topLevelFolderItemFactoryRegistry.addContribution((TopLevelFolderItemFactoryDescriptor)contribution);
        } else if (ACTIVE_FILE_SYSTEM_ITEM_FACTORIES_EP.equals(extensionPoint)) {
            if (contribution instanceof ActiveTopLevelFolderItemFactoryDescriptor) {
                this.activeTopLevelFolderItemFactoryRegistry.addContribution((ActiveTopLevelFolderItemFactoryDescriptor)contribution);
            } else if (contribution instanceof ActiveFileSystemItemFactoriesDescriptor) {
                this.activeFileSystemItemFactoryRegistry.addContribution((ActiveFileSystemItemFactoriesDescriptor)contribution);
            }
        } else {
            log.error((Object)("Unknown extension point " + extensionPoint));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (FILE_SYSTEM_ITEM_FACTORY_EP.equals(extensionPoint)) {
            this.fileSystemItemFactoryRegistry.removeContribution((FileSystemItemFactoryDescriptor)contribution);
        } else if (TOP_LEVEL_FOLDER_ITEM_FACTORY_EP.equals(extensionPoint)) {
            this.topLevelFolderItemFactoryRegistry.removeContribution((TopLevelFolderItemFactoryDescriptor)contribution);
        } else if (ACTIVE_FILE_SYSTEM_ITEM_FACTORIES_EP.equals(extensionPoint)) {
            if (contribution instanceof ActiveTopLevelFolderItemFactoryDescriptor) {
                this.activeTopLevelFolderItemFactoryRegistry.removeContribution((ActiveTopLevelFolderItemFactoryDescriptor)contribution);
            } else if (contribution instanceof ActiveFileSystemItemFactoriesDescriptor) {
                this.activeFileSystemItemFactoryRegistry.removeContribution((ActiveFileSystemItemFactoriesDescriptor)contribution);
            }
        } else {
            log.error((Object)("Unknown extension point " + extensionPoint));
        }
    }

    public void activate(ComponentContext context) {
        this.fileSystemItemFactoryRegistry = new FileSystemItemFactoryRegistry();
        this.topLevelFolderItemFactoryRegistry = new TopLevelFolderItemFactoryRegistry();
        this.activeTopLevelFolderItemFactoryRegistry = new ActiveTopLevelFolderItemFactoryRegistry();
        this.activeFileSystemItemFactoryRegistry = new ActiveFileSystemItemFactoryRegistry();
        this.fileSystemItemFactories = new ArrayList<FileSystemItemFactoryWrapper>();
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
        this.fileSystemItemFactoryRegistry = null;
        this.topLevelFolderItemFactoryRegistry = null;
        this.activeTopLevelFolderItemFactoryRegistry = null;
        this.activeFileSystemItemFactoryRegistry = null;
        this.fileSystemItemFactories = null;
    }

    public void applicationStarted(ComponentContext context) {
        this.setActiveFactories();
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc) {
        return this.getFileSystemItem(doc, false, null, false, false, true);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, boolean includeDeleted) {
        return this.getFileSystemItem(doc, false, null, includeDeleted, false, true);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint) {
        return this.getFileSystemItem(doc, false, null, includeDeleted, relaxSyncRootConstraint, true);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint, boolean getLockInfo) {
        return this.getFileSystemItem(doc, false, null, includeDeleted, relaxSyncRootConstraint, getLockInfo);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, FolderItem parentItem) {
        return this.getFileSystemItem(doc, true, parentItem, false, false, true);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, FolderItem parentItem, boolean includeDeleted) {
        return this.getFileSystemItem(doc, true, parentItem, includeDeleted, false, true);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, FolderItem parentItem, boolean includeDeleted, boolean relaxSyncRootConstraint) {
        return this.getFileSystemItem(doc, true, parentItem, includeDeleted, relaxSyncRootConstraint, true);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, FolderItem parentItem, boolean includeDeleted, boolean relaxSyncRootConstraint, boolean getLockInfo) {
        return this.getFileSystemItem(doc, true, parentItem, includeDeleted, relaxSyncRootConstraint, getLockInfo);
    }

    @Override
    public FileSystemItemFactory getFileSystemItemFactoryForId(String id) {
        for (FileSystemItemFactoryWrapper factoryWrapper : this.fileSystemItemFactories) {
            FileSystemItemFactory factory = factoryWrapper.getFactory();
            if (!factory.canHandleFileSystemItemId(id)) continue;
            return factory;
        }
        if (this.getTopLevelFolderItemFactory().canHandleFileSystemItemId(id)) {
            return this.getTopLevelFolderItemFactory();
        }
        throw new NuxeoDriveContribException(String.format("No fileSystemItemFactory found for FileSystemItem with id %s. Please check the contributions to the following extension point: <extension target=\"org.nuxeo.drive.service.FileSystemItemAdapterService\" point=\"fileSystemItemFactory\"> and make sure there is at least one defining a FileSystemItemFactory class for which the #canHandleFileSystemItemId(String id) method returns true.", id));
    }

    @Override
    public TopLevelFolderItemFactory getTopLevelFolderItemFactory() {
        if (this.topLevelFolderItemFactory == null) {
            throw new NuxeoDriveContribException("Found no active top level folder item factory. Please check there is a contribution to the following extension point: <extension target=\"org.nuxeo.drive.service.FileSystemItemAdapterService\" point=\"topLevelFolderItemFactory\"> and to <extension target=\"org.nuxeo.drive.service.FileSystemItemAdapterService\" point=\"activeTopLevelFolderItemFactory\">.");
        }
        return this.topLevelFolderItemFactory;
    }

    @Override
    public VirtualFolderItemFactory getVirtualFolderItemFactory(String factoryName) {
        FileSystemItemFactory factory = this.getFileSystemItemFactory(factoryName);
        if (factory == null) {
            throw new NuxeoDriveContribException(String.format("No factory named %s. Please check the contributions to the following extension point: <extension target=\"org.nuxeo.drive.service.FileSystemItemAdapterService\" point=\"fileSystemItemFactory\">.", factoryName));
        }
        if (!(factory instanceof VirtualFolderItemFactory)) {
            throw new NuxeoDriveContribException(String.format("Factory class %s for factory %s is not a VirtualFolderItemFactory.", factory.getClass().getName(), factory.getName()));
        }
        return (VirtualFolderItemFactory)factory;
    }

    @Override
    public Set<String> getActiveFileSystemItemFactories() {
        if (this.activeFileSystemItemFactoryRegistry.activeFactories.isEmpty()) {
            throw new NuxeoDriveContribException("Found no active file system item factories. Please check there is a contribution to the following extension point: <extension target=\"org.nuxeo.drive.service.FileSystemItemAdapterService\" point=\"activeFileSystemItemFactories\"> declaring at least one factory.");
        }
        return this.activeFileSystemItemFactoryRegistry.activeFactories;
    }

    public Map<String, FileSystemItemFactoryDescriptor> getFileSystemItemFactoryDescriptors() {
        return this.fileSystemItemFactoryRegistry.factoryDescriptors;
    }

    public List<FileSystemItemFactoryWrapper> getFileSystemItemFactories() {
        return this.fileSystemItemFactories;
    }

    public FileSystemItemFactory getFileSystemItemFactory(String name) {
        for (FileSystemItemFactoryWrapper factoryWrapper : this.fileSystemItemFactories) {
            FileSystemItemFactory factory = factoryWrapper.getFactory();
            if (!name.equals(factory.getName())) continue;
            return factory;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("No fileSystemItemFactory named %s, returning null.", name));
        }
        return null;
    }

    public void setActiveFactories() {
        this.topLevelFolderItemFactory = this.topLevelFolderItemFactoryRegistry.getActiveFactory(this.activeTopLevelFolderItemFactoryRegistry.activeFactory);
        this.fileSystemItemFactories = this.fileSystemItemFactoryRegistry.getOrderedActiveFactories(this.activeFileSystemItemFactoryRegistry.activeFactories);
    }

    protected FileSystemItem getFileSystemItem(DocumentModel doc, boolean forceParentItem, FolderItem parentItem, boolean includeDeleted, boolean relaxSyncRootConstraint, boolean getLockInfo) {
        FileSystemItem fileSystemItem = null;
        fileSystemItem = forceParentItem ? this.getTopLevelFolderItemFactory().getFileSystemItem(doc, parentItem, includeDeleted, relaxSyncRootConstraint, getLockInfo) : this.getTopLevelFolderItemFactory().getFileSystemItem(doc, includeDeleted, relaxSyncRootConstraint, getLockInfo);
        if (fileSystemItem != null) {
            return fileSystemItem;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("The topLevelFolderItemFactory is not able to adapt document %s as a FileSystemItem => trying fileSystemItemFactories.", doc.getId()));
        }
        FileSystemItemFactoryWrapper matchingFactory = null;
        for (FileSystemItemFactoryWrapper factory : this.fileSystemItemFactories) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Trying to adapt document %s (path: %s) as a FileSystemItem with factory %s", doc.getId(), doc.getPathAsString(), factory.getFactory().getName()));
            }
            if (!this.generalFactoryMatches(factory) && !this.docTypeFactoryMatches(factory, doc) && !this.facetFactoryMatches(factory, doc, relaxSyncRootConstraint)) continue;
            matchingFactory = factory;
            try {
                fileSystemItem = forceParentItem ? factory.getFactory().getFileSystemItem(doc, parentItem, includeDeleted, relaxSyncRootConstraint, getLockInfo) : factory.getFactory().getFileSystemItem(doc, includeDeleted, relaxSyncRootConstraint, getLockInfo);
            }
            catch (RootlessItemException e) {
                throw new RootlessItemException(String.format("Cannot find path to registered top level when adapting document  '%s' (path: %s) with factory %s", doc.getTitle(), doc.getPathAsString(), factory.getFactory().getName()), (Throwable)((Object)e));
            }
            if (fileSystemItem == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Adapted document '%s' (path: %s) to item with path %s with factory %s", doc.getTitle(), doc.getPathAsString(), fileSystemItem.getPath(), factory.getFactory().getName()));
            }
            return fileSystemItem;
        }
        if (matchingFactory == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("None of the fileSystemItemFactories matches document %s => returning null. Please check the contributions to the following extension point: <extension target=\"org.nuxeo.drive.service.FileSystemItemAdapterService\" point=\"fileSystemItemFactory\">.", doc.getId()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("None of the fileSystemItemFactories matching document %s were able to adapt this document as a FileSystemItem => returning null.", doc.getId()));
        }
        return fileSystemItem;
    }

    protected boolean generalFactoryMatches(FileSystemItemFactoryWrapper factory) {
        boolean matches;
        boolean bl = matches = StringUtils.isEmpty((String)factory.getDocType()) && StringUtils.isEmpty((String)factory.getFacet());
        if (log.isTraceEnabled() && matches) {
            log.trace((Object)String.format("General factory %s matches", factory));
        }
        return matches;
    }

    protected boolean docTypeFactoryMatches(FileSystemItemFactoryWrapper factory, DocumentModel doc) {
        boolean matches;
        boolean bl = matches = !StringUtils.isEmpty((String)factory.getDocType()) && factory.getDocType().equals(doc.getType());
        if (log.isTraceEnabled() && matches) {
            log.trace((Object)String.format("DocType factory %s matches for doc %s (path: %s)", factory, doc.getId(), doc.getPathAsString()));
        }
        return matches;
    }

    protected boolean facetFactoryMatches(FileSystemItemFactoryWrapper factory, DocumentModel doc, boolean relaxSyncRootConstraint) {
        if (!StringUtils.isEmpty((String)factory.getFacet())) {
            for (String docFacet : doc.getFacets()) {
                if (!factory.getFacet().equals(docFacet)) continue;
                if ("DriveSynchronized".equals(docFacet)) {
                    boolean matches = this.syncRootFactoryMatches(doc, relaxSyncRootConstraint);
                    if (log.isTraceEnabled() && matches) {
                        log.trace((Object)String.format("Facet factory %s matches for doc %s (path: %s)", factory, doc.getId(), doc.getPathAsString()));
                    }
                    return matches;
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("Facet factory %s matches for doc %s (path: %s)", factory, doc.getId(), doc.getPathAsString()));
                }
                return true;
            }
        }
        return false;
    }

    protected boolean syncRootFactoryMatches(DocumentModel doc, boolean relaxSyncRootConstraint) {
        String userName = doc.getCoreSession().getPrincipal().getName();
        List subscriptions = (List)((Object)doc.getPropertyValue("drv:subscriptions"));
        for (Map subscription : subscriptions) {
            if (!Boolean.TRUE.equals(subscription.get("enabled")) || !userName.equals(subscription.get("username")) && !relaxSyncRootConstraint) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Doc %s (path: %s) registered as a sync root for user %s", doc.getId(), doc.getPathAsString(), userName));
            }
            return true;
        }
        return false;
    }
}

