/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.hierarchy.permission.factory;

import java.security.Principal;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.hierarchy.permission.adapter.UserSyncRootParentFolderItem;
import org.nuxeo.drive.hierarchy.userworkspace.adapter.UserWorkspaceHelper;
import org.nuxeo.drive.service.FileSystemItemManager;
import org.nuxeo.drive.service.VirtualFolderItemFactory;
import org.nuxeo.drive.service.impl.AbstractFileSystemItemFactory;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.runtime.api.Framework;

public class UserSyncRootParentFactory
extends AbstractFileSystemItemFactory
implements VirtualFolderItemFactory {
    private static final Log log = LogFactory.getLog(UserSyncRootParentFactory.class);
    protected static final String FOLDER_NAME_PARAM = "folderName";
    protected String folderName;

    @Override
    public void handleParameters(Map<String, String> parameters) {
        String folderNameParam = parameters.get(FOLDER_NAME_PARAM);
        if (StringUtils.isEmpty((String)folderNameParam)) {
            throw new NuxeoException(String.format("Factory %s has no %s parameter, please provide one.", this.getName(), FOLDER_NAME_PARAM));
        }
        this.folderName = folderNameParam;
    }

    @Override
    public boolean isFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint) {
        boolean isUserWorkspace = UserWorkspaceHelper.isUserWorkspace(doc);
        if (!isUserWorkspace) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Document %s is not a user workspace, it cannot be adapted as a FileSystemItem.", doc.getId()));
            }
            return false;
        }
        if (!includeDeleted && "deleted".equals(doc.getCurrentLifeCycleState())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Document %s is in the '%s' life cycle state, it cannot be adapted as a FileSystemItem.", doc.getId(), "deleted"));
            }
            return false;
        }
        return true;
    }

    @Override
    protected FileSystemItem adaptDocument(DocumentModel doc, boolean forceParentItem, FolderItem parentItem, boolean relaxSyncRootConstraint) {
        return new UserSyncRootParentFolderItem(this.getName(), doc, parentItem, this.folderName, relaxSyncRootConstraint);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, boolean includeDeleted) {
        Principal principal = doc.getCoreSession().getPrincipal();
        return this.getFileSystemItem(doc, this.getTopLevelFolderItem(principal), includeDeleted);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint) {
        Principal principal = doc.getCoreSession().getPrincipal();
        return this.getFileSystemItem(doc, this.getTopLevelFolderItem(principal), includeDeleted, relaxSyncRootConstraint);
    }

    @Override
    public FolderItem getVirtualFolderItem(Principal principal) {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        try (CoreSession session = CoreInstance.openCoreSession((String)repositoryManager.getDefaultRepositoryName(), (Principal)principal);){
            UserWorkspaceService userWorkspaceService = (UserWorkspaceService)Framework.getLocalService(UserWorkspaceService.class);
            DocumentModel userWorkspace = userWorkspaceService.getCurrentUserPersonalWorkspace(session, null);
            if (userWorkspace == null) {
                throw new NuxeoException(String.format("No personal workspace found for user %s.", principal.getName()));
            }
            FolderItem folderItem = (FolderItem)this.getFileSystemItem(userWorkspace);
            return folderItem;
        }
    }

    @Override
    public String getFolderName() {
        return this.folderName;
    }

    @Override
    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    protected FolderItem getTopLevelFolderItem(Principal principal) {
        FolderItem topLevelFolder = ((FileSystemItemManager)Framework.getLocalService(FileSystemItemManager.class)).getTopLevelFolder(principal);
        if (topLevelFolder == null) {
            throw new NuxeoException("Found no top level folder item. Please check your contribution to the following extension point: <extension target=\"org.nuxeo.drive.service.FileSystemItemAdapterService\" point=\"topLevelFolderItemFactory\">.");
        }
        return topLevelFolder;
    }
}

