/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.adapter.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.codec.digest.DigestUtils;
import org.nuxeo.drive.service.VersioningFileSystemItemFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;

public final class FileSystemItemHelper {
    public static final String MD5_DIGEST_ALGORITHM = "MD5";

    private FileSystemItemHelper() {
    }

    public static void versionIfNeeded(VersioningFileSystemItemFactory factory, DocumentModel doc, CoreSession session) {
        if (factory.needsVersioning(doc)) {
            doc.putContextData("VersioningOption", (Serializable)factory.getVersioningOption());
            session.saveDocument(doc);
        }
    }

    public static String getMD5Digest(Blob blob) {
        try {
            return DigestUtils.md5Hex((InputStream)blob.getStream());
        }
        catch (IOException e) {
            throw new NuxeoException(String.format("Error while computing digest for blob %s.", blob.getFilename()), (Throwable)e);
        }
    }
}

