/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import java.security.Principal;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.impl.DocumentBackedFileItem;
import org.nuxeo.drive.adapter.impl.DocumentBackedFolderItem;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.VersioningFileSystemItemFactory;
import org.nuxeo.drive.service.impl.AbstractFileSystemItemFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.runtime.api.Framework;

public class DefaultFileSystemItemFactory
extends AbstractFileSystemItemFactory
implements VersioningFileSystemItemFactory {
    private static final Log log = LogFactory.getLog(DefaultFileSystemItemFactory.class);
    protected static final String VERSIONING_DELAY_PARAM = "versioningDelay";
    protected static final String VERSIONING_OPTION_PARAM = "versioningOption";
    protected double versioningDelay = 3600.0;
    protected VersioningOption versioningOption = VersioningOption.MINOR;

    @Override
    public void handleParameters(Map<String, String> parameters) {
        String versioningOptionParam;
        String versioningDelayParam = parameters.get(VERSIONING_DELAY_PARAM);
        if (!StringUtils.isEmpty((String)versioningDelayParam)) {
            this.versioningDelay = Double.parseDouble(versioningDelayParam);
        }
        if (!StringUtils.isEmpty((String)(versioningOptionParam = parameters.get(VERSIONING_OPTION_PARAM)))) {
            this.versioningOption = VersioningOption.valueOf((String)versioningOptionParam);
        }
    }

    @Override
    public boolean isFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint) {
        Principal principal;
        NuxeoDriveManager nuxeoDriveManager;
        boolean isSyncRoot;
        BlobHolder bh;
        BlobManager blobManager;
        BlobProvider blobProvider;
        if (doc.isVersion()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Document %s is a version, it cannot be adapted as a FileSystemItem.", doc.getId()));
            }
            return false;
        }
        if ("Collections".equals(doc.getType())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Document %s is the collection root folder (type=%s, path=%s), it cannot be adapted as a FileSystemItem.", doc.getId(), "Collections", doc.getPathAsString()));
            }
            return false;
        }
        if (doc.hasFacet("HiddenInNavigation")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Document %s is HiddenInNavigation, it cannot be adapted as a FileSystemItem.", doc.getId()));
            }
            return false;
        }
        if (!includeDeleted && "deleted".equals(doc.getCurrentLifeCycleState())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Document %s is in the '%s' life cycle state, it cannot be adapted as a FileSystemItem.", doc.getId(), "deleted"));
            }
            return false;
        }
        if (!doc.isFolder() && !this.hasBlob(doc)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Document %s is not Folderish nor a BlobHolder with a blob, it cannot be adapted as a FileSystemItem.", doc.getId()));
            }
            return false;
        }
        if (!(doc.isFolder() || (blobProvider = (blobManager = (BlobManager)Framework.getService(BlobManager.class)).getBlobProvider((bh = (BlobHolder)doc.getAdapter(BlobHolder.class)).getBlob())) == null || blobProvider.supportsUserUpdate() && blobProvider.getBinaryManager() != null)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Blob for Document %s is backed by a BlobProvider preventing updates, it cannot be adapted as a FileSystemItem.", doc.getId()));
            }
            return false;
        }
        if (!relaxSyncRootConstraint && doc.isFolder() && (isSyncRoot = (nuxeoDriveManager = (NuxeoDriveManager)Framework.getLocalService(NuxeoDriveManager.class)).isSynchronizationRoot(principal = doc.getCoreSession().getPrincipal(), doc))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Document %s is a registered synchronization root for user %s, it cannot be adapted as a DefaultFileSystemItem.", doc.getId(), principal.getName()));
            }
            return false;
        }
        return true;
    }

    @Override
    protected FileSystemItem adaptDocument(DocumentModel doc, boolean forceParentItem, FolderItem parentItem, boolean relaxSyncRootConstraint) {
        if (doc.isFolder()) {
            if (forceParentItem) {
                return new DocumentBackedFolderItem(this.name, parentItem, doc, relaxSyncRootConstraint);
            }
            return new DocumentBackedFolderItem(this.name, doc, relaxSyncRootConstraint);
        }
        if (forceParentItem) {
            return new DocumentBackedFileItem(this, parentItem, doc, relaxSyncRootConstraint);
        }
        return new DocumentBackedFileItem((VersioningFileSystemItemFactory)this, doc, relaxSyncRootConstraint);
    }

    @Override
    public boolean needsVersioning(DocumentModel doc) {
        long versioningDelayMillis;
        boolean contributorChanged;
        String lastContributor = (String)((Object)doc.getPropertyValue("dc:lastContributor"));
        Principal principal = doc.getCoreSession().getPrincipal();
        boolean bl = contributorChanged = !principal.getName().equals(lastContributor);
        if (contributorChanged) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Contributor %s is different from the last contributor %s => will create a version of the document.", principal.getName(), lastContributor));
            }
            return true;
        }
        Calendar lastModificationDate = (Calendar)doc.getPropertyValue("dc:modified");
        if (lastModificationDate == null) {
            log.debug((Object)"Last modification date is null => will not create a version of the document.");
            return true;
        }
        long lastModified = System.currentTimeMillis() - lastModificationDate.getTimeInMillis();
        if (lastModified > (versioningDelayMillis = (long)this.getVersioningDelay() * 1000L)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Last modification was done %d milliseconds ago, this is more than the versioning delay %d milliseconds => will create a version of the document.", lastModified, versioningDelayMillis));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Contributor %s is the last contributor and last modification was done %d milliseconds ago, this is less than the versioning delay %d milliseconds => will not create a version of the document.", principal.getName(), lastModified, versioningDelayMillis));
        }
        return false;
    }

    @Override
    public double getVersioningDelay() {
        return this.versioningDelay;
    }

    @Override
    public void setVersioningDelay(double versioningDelay) {
        this.versioningDelay = versioningDelay;
    }

    @Override
    public VersioningOption getVersioningOption() {
        return this.versioningOption;
    }

    @Override
    public void setVersioningOption(VersioningOption versioningOption) {
        this.versioningOption = versioningOption;
    }

    protected boolean hasBlob(DocumentModel doc) {
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (bh == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Document %s is not a BlobHolder.", doc.getId()));
            }
            return false;
        }
        Blob blob = bh.getBlob();
        if (blob == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Document %s is a BlobHolder without a blob.", doc.getId()));
            }
            return false;
        }
        return true;
    }
}

