/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.elasticsearch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortOrder;
import org.nuxeo.drive.service.SynchronizationRoots;
import org.nuxeo.drive.service.impl.AuditChangeFinder;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.audit.io.AuditEntryJSONReader;
import org.nuxeo.runtime.api.Framework;

public class ESAuditChangeFinder
extends AuditChangeFinder {
    private static final long serialVersionUID = 1L;
    public static final Log log = LogFactory.getLog(ESAuditChangeFinder.class);
    protected Client esClient = null;

    protected List<LogEntry> queryESAuditEntries(CoreSession session, SynchronizationRoots activeRoots, Set<String> collectionSyncRootMemberIds, long lowerBound, long upperBound, boolean integerBounds, int limit) {
        SearchRequestBuilder builder = this.getClient().prepareSearch(new String[]{this.getESIndexName()}).setTypes(new String[]{"entry"}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH);
        MatchAllQueryBuilder queryBuilder = QueryBuilders.matchAllQuery();
        QueryBuilder filterBuilder = this.buildFilterClauses(session, activeRoots, collectionSyncRootMemberIds, lowerBound, upperBound, integerBounds, limit);
        builder.setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)queryBuilder).filter(filterBuilder));
        builder.addSort("repositoryId", SortOrder.ASC);
        builder.addSort("eventDate", SortOrder.DESC);
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        this.logSearchRequest(builder);
        SearchResponse searchResponse = (SearchResponse)builder.setSize(limit).execute().actionGet();
        this.logSearchResponse(searchResponse);
        for (SearchHit hit : searchResponse.getHits()) {
            try {
                entries.add(AuditEntryJSONReader.read((String)hit.getSourceAsString()));
            }
            catch (IOException e) {
                log.error((Object)"Error while reading Audit Entry from ES", (Throwable)e);
            }
        }
        return entries;
    }

    protected QueryBuilder buildFilterClauses(CoreSession session, SynchronizationRoots activeRoots, Set<String> collectionSyncRootMemberIds, long lowerBound, long upperBound, boolean integerBounds, int limit) {
        BoolQueryBuilder filterBuilder = QueryBuilders.boolQuery();
        TermQueryBuilder repositoryClauseFilter = QueryBuilders.termQuery((String)"repositoryId", (String)session.getRepositoryName());
        filterBuilder.must((QueryBuilder)repositoryClauseFilter);
        if (activeRoots.getPaths().isEmpty()) {
            filterBuilder.must((QueryBuilder)this.getDriveLogsQueryClause());
        } else {
            BoolQueryBuilder orFilterBuilderIfActiveRoots = QueryBuilders.boolQuery();
            String[] eventIds = new String[]{"documentCreated", "documentModified", "documentMoved", "documentCreatedByCopy", "documentRestored", "addedToCollection", "documentProxyPublished", "documentLocked", "documentUnlocked"};
            BoolQueryBuilder orEventsFilter = QueryBuilders.boolQuery();
            orEventsFilter.should((QueryBuilder)this.getEventsClause("eventDocumentCategory", eventIds, true));
            orEventsFilter.should((QueryBuilder)this.getEventsClause("eventLifeCycleCategory", new String[]{"lifecycle_transition_event"}, true));
            orEventsFilter.should((QueryBuilder)this.getEventsClause("eventLifeCycleCategory", new String[]{"deleted"}, false));
            if (collectionSyncRootMemberIds != null && collectionSyncRootMemberIds.size() > 0) {
                BoolQueryBuilder rootsOrCollectionsFilter = QueryBuilders.boolQuery();
                rootsOrCollectionsFilter.should((QueryBuilder)this.getCurrentRootsClause(activeRoots.getPaths()));
                rootsOrCollectionsFilter.should((QueryBuilder)this.getCollectionSyncRootClause(collectionSyncRootMemberIds));
                orFilterBuilderIfActiveRoots.should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)orEventsFilter).must((QueryBuilder)rootsOrCollectionsFilter));
            } else {
                orFilterBuilderIfActiveRoots.should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)orEventsFilter).must((QueryBuilder)this.getCurrentRootsClause(activeRoots.getPaths())));
            }
            orFilterBuilderIfActiveRoots.should((QueryBuilder)this.getDriveLogsQueryClause());
            filterBuilder.must((QueryBuilder)orFilterBuilderIfActiveRoots);
        }
        filterBuilder.must((QueryBuilder)this.getLogIdBoundsClause(lowerBound, upperBound));
        return filterBuilder;
    }

    protected RangeQueryBuilder getLogIdBoundsClause(long lowerBound, long upperBound) {
        RangeQueryBuilder rangeFilter = QueryBuilders.rangeQuery((String)"id");
        rangeFilter.gt(lowerBound);
        rangeFilter.lte(upperBound);
        return rangeFilter;
    }

    protected TermsQueryBuilder getCollectionSyncRootClause(Set<String> collectionSyncRootMemberIds) {
        return QueryBuilders.termsQuery((String)"docUUID", collectionSyncRootMemberIds);
    }

    protected BoolQueryBuilder getCurrentRootsClause(Set<String> rootPaths) {
        BoolQueryBuilder orFilterRoots = QueryBuilders.boolQuery();
        for (String rootPath : rootPaths) {
            orFilterRoots.should((QueryBuilder)QueryBuilders.prefixQuery((String)"docPath", (String)rootPath));
        }
        return orFilterRoots;
    }

    protected BoolQueryBuilder getDriveLogsQueryClause() {
        BoolQueryBuilder filterBuilder = QueryBuilders.boolQuery();
        filterBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"category", (String)"NuxeoDrive"));
        filterBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"eventId", (String)"rootUnregistered"));
        return filterBuilder;
    }

    protected BoolQueryBuilder getEventsClause(String category, String[] eventIds, boolean shouldMatch) {
        BoolQueryBuilder filterBuilder = QueryBuilders.boolQuery();
        filterBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"category", (String)category));
        if (eventIds != null && eventIds.length > 0) {
            if (eventIds.length == 1) {
                if (shouldMatch) {
                    filterBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"eventId", (String)eventIds[0]));
                } else {
                    filterBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"eventId", (String)eventIds[0]));
                }
            } else if (shouldMatch) {
                filterBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"eventId", (String[])eventIds));
            } else {
                filterBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"eventId", (String[])eventIds));
            }
        }
        return filterBuilder;
    }

    public long getUpperBound() {
        SearchRequestBuilder builder = this.getClient().prepareSearch(new String[]{this.getESIndexName()}).setTypes(new String[]{"entry"}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH);
        builder.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
        builder.addSort("id", SortOrder.DESC);
        builder.setSize(1);
        this.logSearchRequest(builder);
        SearchResponse searchResponse = (SearchResponse)builder.execute().actionGet();
        this.logSearchResponse(searchResponse);
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        SearchHits hits = searchResponse.getHits();
        for (SearchHit hit : hits) {
            try {
                entries.add(AuditEntryJSONReader.read((String)hit.getSourceAsString()));
            }
            catch (IOException e) {
                log.error((Object)"Error while reading Audit Entry from ES", (Throwable)e);
            }
        }
        return entries.size() > 0 ? ((LogEntry)entries.get(0)).getId() : -1L;
    }

    public long getUpperBound(Set<String> repositoryNames) {
        SearchRequestBuilder builder = this.getClient().prepareSearch(new String[]{this.getESIndexName()}).setTypes(new String[]{"entry"}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH);
        MatchAllQueryBuilder queryBuilder = QueryBuilders.matchAllQuery();
        long clusteringDelay = this.getClusteringDelay(repositoryNames);
        if (clusteringDelay > -1L) {
            long lastClusteringInvalidationDate = System.currentTimeMillis() - 2L * clusteringDelay;
            RangeQueryBuilder filterBuilder = QueryBuilders.rangeQuery((String)"logDate").lt((Object)new Date(lastClusteringInvalidationDate));
            builder.setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)queryBuilder).filter((QueryBuilder)filterBuilder));
        } else {
            builder.setQuery((QueryBuilder)queryBuilder);
        }
        builder.addSort("id", SortOrder.DESC);
        builder.setSize(1);
        this.logSearchRequest(builder);
        SearchResponse searchResponse = (SearchResponse)builder.execute().actionGet();
        this.logSearchResponse(searchResponse);
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        SearchHits hits = searchResponse.getHits();
        for (SearchHit hit : hits) {
            try {
                entries.add(AuditEntryJSONReader.read((String)hit.getSourceAsString()));
            }
            catch (IOException e) {
                log.error((Object)"Error while reading Audit Entry from ES", (Throwable)e);
            }
        }
        if (entries.isEmpty()) {
            if (clusteringDelay > -1L) {
                builder.setQuery((QueryBuilder)queryBuilder);
                this.logSearchRequest(builder);
                searchResponse = (SearchResponse)builder.execute().actionGet();
                this.logSearchResponse(searchResponse);
                if (searchResponse.getHits().iterator().hasNext()) {
                    log.debug((Object)"Found no audit log entries matching the criterias but some exist, returning 0");
                    return 0L;
                }
            }
            log.debug((Object)"Found no audit log entries, returning -1");
            return -1L;
        }
        return ((LogEntry)entries.get(0)).getId();
    }

    protected List<LogEntry> queryAuditEntries(CoreSession session, SynchronizationRoots activeRoots, Set<String> collectionSyncRootMemberIds, long lowerBound, long upperBound, boolean integerBounds, int limit) {
        List<LogEntry> entries = this.queryESAuditEntries(session, activeRoots, collectionSyncRootMemberIds, lowerBound, upperBound, integerBounds, limit);
        ArrayList<LogEntry> postFilteredEntries = new ArrayList<LogEntry>();
        String principalName = session.getPrincipal().getName();
        for (LogEntry entry : entries) {
            ExtendedInfo impactedUserInfo = (ExtendedInfo)entry.getExtendedInfos().get("impactedUserName");
            if (impactedUserInfo != null && !principalName.equals(impactedUserInfo.getValue(String.class))) continue;
            if (log.isDebugEnabled() && log.isDebugEnabled()) {
                log.debug((Object)String.format("Change detected: %s", entry));
            }
            postFilteredEntries.add(entry);
        }
        return postFilteredEntries;
    }

    protected Client getClient() {
        if (this.esClient == null) {
            ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
            this.esClient = esa.getClient();
        }
        return this.esClient;
    }

    protected String getESIndexName() {
        ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
        return esa.getIndexNameForType("entry");
    }

    protected void logSearchRequest(SearchRequestBuilder request) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Elasticsearch search request: curl -XGET 'http://localhost:9200/%s/%s/_search?pretty' -d '%s'", this.getESIndexName(), "entry", request.toString()));
        }
    }

    protected void logSearchResponse(SearchResponse response) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Elasticsearch search response: " + response.toString()));
        }
    }
}

