/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.elasticsearch;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.impl.DefaultSyncRootFolderItem;
import org.nuxeo.drive.adapter.impl.ScrollDocumentModelList;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.api.EsScrollResult;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.runtime.api.Framework;

public class ESSyncRootFolderItem
extends DefaultSyncRootFolderItem {
    private static final long serialVersionUID = 1020938498677864484L;
    private static final Log log = LogFactory.getLog(ESSyncRootFolderItem.class);

    public ESSyncRootFolderItem(String factoryName, FolderItem parentItem, DocumentModel doc) {
        super(factoryName, parentItem, doc);
    }

    public ESSyncRootFolderItem(String factoryName, FolderItem parentItem, DocumentModel doc, boolean relaxSyncRootConstraint) {
        super(factoryName, parentItem, doc, relaxSyncRootConstraint);
    }

    public ESSyncRootFolderItem(String factoryName, FolderItem parentItem, DocumentModel doc, boolean relaxSyncRootConstraint, boolean getLockInfo) {
        super(factoryName, parentItem, doc, relaxSyncRootConstraint, getLockInfo);
    }

    protected ESSyncRootFolderItem() {
    }

    protected ScrollDocumentModelList getScrollBatch(String scrollId, int batchSize, CoreSession session, long keepAlive) {
        EsScrollResult res;
        ElasticSearchService ess = (ElasticSearchService)Framework.getService(ElasticSearchService.class);
        StringBuilder sb = new StringBuilder(String.format("SELECT * FROM Document WHERE ecm:ancestorId = '%s'", this.docId));
        sb.append(" AND ecm:currentLifeCycleState != 'deleted'");
        sb.append(" AND ecm:mixinType != 'HiddenInNavigation'");
        sb.append(" AND ecm:isCheckedInVersion = 0");
        sb.append(" ORDER BY ecm:path");
        String query = sb.toString();
        NxQueryBuilder queryBuilder = new NxQueryBuilder(session).nxql(query).limit(batchSize);
        if (StringUtils.isEmpty((String)scrollId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Executing Elasticsearch initial search request to scroll through the descendants of %s with batchSize = %d and keepAlive = %d: %s", this.docPath, batchSize, keepAlive, query));
            }
            res = ess.scroll(queryBuilder, keepAlive);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Scrolling through the descendants of %s with scrollId = %s, batchSize = %s and keepAlive = %s", this.docPath, scrollId, batchSize, keepAlive));
            }
            res = ess.scroll(new EsScrollResult(queryBuilder, scrollId, keepAlive));
        }
        return new ScrollDocumentModelList(res.getScrollId(), res.getDocuments());
    }
}

