/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.adapter.impl;

import java.io.IOException;
import java.util.ArrayList;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.BooleanNode;
import org.codehaus.jackson.node.TextNode;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.ScrollFileSystemItemList;
import org.nuxeo.drive.adapter.impl.DocumentBackedFileItem;
import org.nuxeo.drive.adapter.impl.DocumentBackedFolderItem;
import org.nuxeo.drive.adapter.impl.ScrollFileSystemItemListImpl;

public class ScrollFileSystemItemListDeserializer
extends JsonDeserializer<ScrollFileSystemItemList> {
    public ScrollFileSystemItemList deserialize(JsonParser jp, DeserializationContext dc) throws IOException {
        JsonNode rootNode = jp.readValueAsTree();
        String scrollId = ((TextNode)rootNode.get("scrollId")).getTextValue();
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode fileSystemItemNodes = (ArrayNode)rootNode.get("fileSystemItems");
        ArrayList<FileSystemItem> fileSystemItems = new ArrayList<FileSystemItem>(fileSystemItemNodes.size());
        for (JsonNode fileSystemItemNode : fileSystemItemNodes) {
            boolean folderish = ((BooleanNode)fileSystemItemNode.get("folder")).getBooleanValue();
            if (folderish) {
                fileSystemItems.add((FileSystemItem)mapper.readValue(fileSystemItemNode, DocumentBackedFolderItem.class));
                continue;
            }
            fileSystemItems.add((FileSystemItem)mapper.readValue(fileSystemItemNode, DocumentBackedFileItem.class));
        }
        return new ScrollFileSystemItemListImpl(scrollId, fileSystemItems);
    }
}

