/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import java.security.Principal;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.service.VirtualFolderItemFactory;
import org.nuxeo.ecm.core.api.DocumentModel;

public abstract class AbstractVirtualFolderItemFactory
implements VirtualFolderItemFactory {
    private static final Log log = LogFactory.getLog(AbstractVirtualFolderItemFactory.class);
    protected static final String FOLDER_NAME_PARAM = "folderName";
    protected static final String DEFAULT_FOLDER_NAME = "Nuxeo Drive";
    protected String name;
    protected String folderName = "Nuxeo Drive";

    @Override
    public abstract FolderItem getVirtualFolderItem(Principal var1);

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void handleParameters(Map<String, String> parameters) {
        String folderNameParam = parameters.get(FOLDER_NAME_PARAM);
        if (!StringUtils.isEmpty((String)folderNameParam)) {
            this.folderName = folderNameParam;
        } else {
            log.info((Object)String.format("Factory %s has no %s parameter, you can provide one in the factory contribution to avoid using the default value '%s'.", this.getName(), FOLDER_NAME_PARAM, DEFAULT_FOLDER_NAME));
        }
    }

    @Override
    public boolean isFileSystemItem(DocumentModel doc) {
        return this.isFileSystemItem(doc, false);
    }

    @Override
    public boolean isFileSystemItem(DocumentModel doc, boolean includeDeleted) {
        return this.isFileSystemItem(doc, false, false);
    }

    @Override
    public boolean isFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint) {
        return false;
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc) {
        return this.getFileSystemItem(doc, false);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, boolean includeDeleted) {
        return this.getFileSystemItem(doc, false, false);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint) {
        return this.getFileSystemItem(doc, false, false, true);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint, boolean getLockInfo) {
        return null;
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, FolderItem parentItem) {
        return this.getFileSystemItem(doc, parentItem, false);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, FolderItem parentItem, boolean includeDeleted) {
        return this.getFileSystemItem(doc, parentItem, false, false);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, FolderItem parentItem, boolean includeDeleted, boolean relaxSyncRootConstraint) {
        return this.getFileSystemItem(doc, parentItem, false, false, true);
    }

    @Override
    public FileSystemItem getFileSystemItem(DocumentModel doc, FolderItem parentItem, boolean includeDeleted, boolean relaxSyncRootConstraint, boolean getLockInfo) {
        return null;
    }

    @Override
    public boolean canHandleFileSystemItemId(String id) {
        return (this.getName() + "#").equals(id);
    }

    @Override
    public boolean exists(String id, Principal principal) {
        if (!this.canHandleFileSystemItemId(id)) {
            throw new UnsupportedOperationException(String.format("Cannot check if a file system item exists for an id that cannot be handled from factory %s.", this.getName()));
        }
        return true;
    }

    @Override
    public FileSystemItem getFileSystemItemById(String id, Principal principal) {
        if (!this.canHandleFileSystemItemId(id)) {
            throw new UnsupportedOperationException(String.format("Cannot get the file system item for an id that cannot be handled from factory %s.", this.getName()));
        }
        return this.getVirtualFolderItem(principal);
    }

    @Override
    public FileSystemItem getFileSystemItemById(String id, String parentId, Principal principal) {
        return this.getFileSystemItemById(id, principal);
    }

    @Override
    @Deprecated
    public DocumentModel getDocumentByFileSystemId(String id, Principal principal) {
        throw new UnsupportedOperationException(String.format("Cannot get document by file system item id from VirtualFolderItemFactory %s.", this.getName()));
    }

    @Override
    public String getFolderName() {
        return this.folderName;
    }

    @Override
    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }
}

