/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations;

import java.io.IOException;
import javax.mail.internet.ParseException;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.drive.adapter.FileItem;
import org.nuxeo.drive.operations.NuxeoDriveOperationHelper;
import org.nuxeo.drive.service.FileSystemItemManager;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.runtime.api.Framework;

@Operation(id="NuxeoDrive.CreateFile", category="Services", label="Nuxeo Drive: Create file")
public class NuxeoDriveCreateFile {
    public static final String ID = "NuxeoDrive.CreateFile";
    @Context
    protected OperationContext ctx;
    @Param(name="parentId")
    protected String parentId;
    @Param(name="overwrite", required=false)
    protected boolean overwrite;
    @Deprecated
    @Param(name="name", required=false)
    protected String name;

    @OperationMethod
    public Blob run(Blob blob) throws ParseException, IOException {
        FileSystemItemManager fileSystemItemManager = (FileSystemItemManager)Framework.getLocalService(FileSystemItemManager.class);
        if (StringUtils.isNotBlank((String)this.name)) {
            blob.setFilename(this.name);
        }
        NuxeoDriveOperationHelper.normalizeMimeTypeAndEncoding(blob);
        FileItem fileItem = fileSystemItemManager.createFile(this.parentId, blob, this.ctx.getPrincipal(), this.overwrite);
        return NuxeoDriveOperationHelper.asJSONBlob(fileItem);
    }
}

