/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.jtajca.internal;

import com.codahale.metrics.JmxAttributeGauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.nuxeo.ecm.core.api.CoreSessionService;
import org.nuxeo.ecm.core.management.jtajca.CoreSessionMonitor;
import org.nuxeo.ecm.core.management.jtajca.Defaults;
import org.nuxeo.ecm.core.management.jtajca.internal.DefaultMonitorComponent;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;

public class DefaultCoreSessionMonitor
implements CoreSessionMonitor {
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected DefaultMonitorComponent.ServerInstance self;

    @Override
    public int getCount() {
        return ((CoreSessionService)Framework.getService(CoreSessionService.class)).getNumberOfOpenCoreSessions();
    }

    @Override
    public String[] getInfos() {
        List infos = ((CoreSessionService)Framework.getService(CoreSessionService.class)).getCoreSessionRegistrationInfos();
        return this.toInfos(this.toSortedRegistration(infos));
    }

    public CoreSessionService.CoreSessionRegistrationInfo[] toSortedRegistration(List<CoreSessionService.CoreSessionRegistrationInfo> infos) {
        CoreSessionService.CoreSessionRegistrationInfo[] sortedInfos = infos.toArray(new CoreSessionService.CoreSessionRegistrationInfo[infos.size()]);
        Arrays.sort(sortedInfos, new Comparator<CoreSessionService.CoreSessionRegistrationInfo>(){

            @Override
            public int compare(CoreSessionService.CoreSessionRegistrationInfo o1, CoreSessionService.CoreSessionRegistrationInfo o2) {
                return o2.getCoreSession().getSessionId().compareTo(o1.getCoreSession().getSessionId());
            }
        });
        return sortedInfos;
    }

    public String[] toInfos(CoreSessionService.CoreSessionRegistrationInfo[] infos) {
        String[] values = new String[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            values[i] = Defaults.instance.printStackTrace(infos[i]);
        }
        return values;
    }

    @Override
    public void install() {
        this.self = DefaultMonitorComponent.bind(CoreSessionMonitor.class, this);
        this.registry.register(MetricRegistry.name((String)"nuxeo.repositories", (String[])new String[]{"sessions"}), (Metric)new JmxAttributeGauge(this.self.name, "Count"));
    }

    @Override
    public void uninstall() {
        DefaultMonitorComponent.unbind(this.self);
        this.registry.remove(MetricRegistry.name((String)"nuxeo.repositories", (String[])new String[]{"sessions"}));
        this.self = null;
    }
}

