/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.listener.NuxeoDriveFileSystemDeletionListener;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.PostCommitFilteringEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class NuxeoDriveGroupUpdateListener
implements PostCommitFilteringEventListener {
    protected static final Log log = LogFactory.getLog(NuxeoDriveFileSystemDeletionListener.class);

    public boolean acceptEvent(Event event) {
        return event.getContext() != null && "userGroup".equals(event.getContext().getProperty("category"));
    }

    public void handleEvent(EventBundle events) {
        for (Event event : events) {
            String groupName;
            EventContext context = event.getContext();
            if (context == null || (groupName = (String)((Object)context.getProperty("id"))) == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("NuxeoDriveGroupUpdateListener handling %s event for group %s", event.getName(), groupName));
            }
            List<String> groupNames = this.getAllGroupNames(groupName, context);
            this.handleUpdatedGroups(groupNames);
        }
    }

    protected List<String> getAllGroupNames(String groupName, EventContext context) {
        ArrayList<String> groupNames = new ArrayList<String>();
        groupNames.add(groupName);
        List ancestorGroups = (List)((Object)context.getProperty("ancestorGroups"));
        if (ancestorGroups != null) {
            groupNames.addAll(ancestorGroups);
        } else {
            groupNames.addAll(((UserManager)Framework.getService(UserManager.class)).getAncestorGroups(groupName));
        }
        return groupNames;
    }

    protected void handleUpdatedGroups(List<String> groupNames) {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        for (String repositoryName : repositoryManager.getRepositoryNames()) {
            CoreInstance.doPrivileged((String)repositoryName, session -> {
                DocumentModelList impactedDocuments = this.getImpactedDocuments((CoreSession)session, groupNames);
                impactedDocuments.forEach(doc -> this.fireGroupUpdatedEvent((CoreSession)session, (DocumentModel)doc));
            });
        }
    }

    protected DocumentModelList getImpactedDocuments(CoreSession session, List<String> groupNames) {
        String groups = groupNames.stream().map(NXQL::escapeString).collect(Collectors.joining(","));
        String query = "SELECT * FROM Document WHERE ecm:currentLifeCycleState != 'deleted' AND ecm:isVersion = 0 AND ecm:acl/*/principal IN (" + groups + ")";
        return session.query(query);
    }

    protected void fireGroupUpdatedEvent(CoreSession session, DocumentModel source) {
        DocumentEventContext context = new DocumentEventContext(session, session.getPrincipal(), source);
        Event event = context.newEvent("groupUpdated");
        ((EventService)Framework.getService(EventService.class)).fireEvent(event);
    }
}

