/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations;

import java.io.IOException;
import java.util.Map;
import org.nuxeo.drive.service.FileSystemChangeSummary;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.impl.RootDefinitionsHelper;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.runtime.api.Framework;

@Operation(id="NuxeoDrive.GetChangeSummary", category="Services", label="Nuxeo Drive: Get change summary")
public class NuxeoDriveGetChangeSummary {
    public static final String ID = "NuxeoDrive.GetChangeSummary";
    @Context
    protected OperationContext ctx;
    @Param(name="lastSyncDate", required=false)
    protected Long lastSyncDate = -1L;
    @Param(name="lowerBound", required=false)
    protected Long lowerBound = -1L;
    @Param(name="lastSyncActiveRootDefinitions", required=false)
    protected String lastSyncActiveRootDefinitions;

    @OperationMethod
    public Blob run() throws IOException {
        NuxeoDriveManager driveManager = (NuxeoDriveManager)Framework.getLocalService(NuxeoDriveManager.class);
        Map lastActiveRootRefs = RootDefinitionsHelper.parseRootDefinitions((String)this.lastSyncActiveRootDefinitions);
        FileSystemChangeSummary docChangeSummary = this.lastSyncDate >= 0L ? driveManager.getChangeSummary(this.ctx.getPrincipal(), lastActiveRootRefs, this.lastSyncDate.longValue()) : driveManager.getChangeSummaryIntegerBounds(this.ctx.getPrincipal(), lastActiveRootRefs, this.lowerBound.longValue());
        return Blobs.createJSONBlobFromValueJackson1((Object)docChangeSummary);
    }
}

