/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.jtajca.internal;

import com.codahale.metrics.JmxAttributeGauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import org.nuxeo.ecm.core.management.jtajca.ConnectionPoolMonitor;
import org.nuxeo.ecm.core.management.jtajca.internal.DefaultMonitorComponent;
import org.nuxeo.runtime.jtajca.NuxeoConnectionManager;
import org.nuxeo.runtime.jtajca.NuxeoContainer;
import org.nuxeo.runtime.metrics.MetricsService;

public class DefaultConnectionPoolMonitor
implements ConnectionPoolMonitor {
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected final String name;
    protected NuxeoConnectionManager cm;
    protected DefaultMonitorComponent.ServerInstance self;

    protected DefaultConnectionPoolMonitor(String mame, NuxeoConnectionManager cm) {
        this.name = mame;
        this.cm = cm;
    }

    public NuxeoConnectionManager getManager() {
        return this.cm;
    }

    @Override
    public void install() {
        this.self = DefaultMonitorComponent.bind(this, this.name);
        this.registry.register(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"repositories", this.name, "connections", "count"}), (Metric)new JmxAttributeGauge(this.self.name, "ConnectionCount"));
        this.registry.register(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"repositories", this.name, "connections", "idle"}), (Metric)new JmxAttributeGauge(this.self.name, "IdleConnectionCount"));
        this.registry.register(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"repositories", this.name, "connections", "killed"}), (Metric)new JmxAttributeGauge(this.self.name, "KilledActiveConnectionCount"));
    }

    @Override
    public void uninstall() {
        DefaultMonitorComponent.unbind(this.self);
        this.registry.remove(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"repositories", this.name, "connections", "count"}));
        this.registry.remove(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"repositories", this.name, "connections", "idle"}));
        this.registry.remove(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"repositories", this.name, "connections", "killed"}));
        this.self = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getConnectionCount() {
        return this.cm.getConnectionCount();
    }

    public int getIdleConnectionCount() {
        return this.cm.getIdleConnectionCount();
    }

    public int getBlockingTimeoutMilliseconds() {
        return this.cm.getBlockingTimeoutMilliseconds();
    }

    public int getIdleTimeoutMinutes() {
        return this.cm.getIdleTimeoutMinutes();
    }

    @Override
    public int getActiveTimeoutMinutes() {
        return this.cm.getActiveTimeoutMinutes();
    }

    public int getPartitionCount() {
        return this.cm.getPartitionCount();
    }

    public int getPartitionMaxSize() {
        return this.cm.getPartitionMaxSize();
    }

    public void setPartitionMaxSize(int maxSize) throws InterruptedException {
        this.cm.setPartitionMaxSize(maxSize);
    }

    public int getPartitionMinSize() {
        return this.cm.getPartitionMinSize();
    }

    public void setPartitionMinSize(int minSize) {
        this.cm.setPartitionMinSize(minSize);
    }

    public void setBlockingTimeoutMilliseconds(int timeoutMilliseconds) {
        this.cm.setBlockingTimeoutMilliseconds(timeoutMilliseconds);
    }

    public void setIdleTimeoutMinutes(int idleTimeoutMinutes) {
        this.cm.setIdleTimeoutMinutes(idleTimeoutMinutes);
    }

    public void handleNewConnectionManager(NuxeoConnectionManager cm) {
        this.cm = cm;
    }

    @Override
    public void reset() {
        NuxeoContainer.resetConnectionManager((String)this.name);
    }

    @Override
    public long getKilledActiveConnectionCount() {
        return this.cm.getKilledConnectionCount();
    }

    @Override
    public int killActiveTimedoutConnections() {
        return this.cm.killActiveTimedoutConnections(System.currentTimeMillis()).size();
    }
}

