/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.listener;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.NuxeoDriveContribException;
import org.nuxeo.drive.adapter.RootlessItemException;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.drive.service.impl.NuxeoDriveManagerImpl;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.runtime.api.Framework;

public class NuxeoDriveFileSystemDeletionListener
implements EventListener {
    private static final Log log = LogFactory.getLog(NuxeoDriveFileSystemDeletionListener.class);

    public void handleEvent(Event event) {
        if (!(event.getContext() instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext ctx = (DocumentEventContext)event.getContext();
        DocumentModel doc = ctx.getSourceDocument();
        if (doc.hasFacet("SystemDocument")) {
            return;
        }
        DocumentModel docForLogEntry = doc;
        if ("beforeDocumentModification".equals(event.getName()) && (docForLogEntry = this.handleBeforeDocUpdate(ctx, doc)) == null) {
            return;
        }
        if ("lifecycle_transition_event".equals(event.getName()) && !this.handleLifeCycleTransition(ctx)) {
            return;
        }
        if ("aboutToRemove".equals(event.getName()) && !this.handleAboutToRemove(doc)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("NuxeoDriveFileSystemDeletionListener handling %s event for %s", event.getName(), doc));
        }
        String virtualEventName = "beforeDocumentSecurityModification".equals(event.getName()) || "groupUpdated".equals(event.getName()) ? "securityUpdated" : ("aboutToMove".equals(event.getName()) ? "moved" : "deleted");
        String impactedUserName = (String)((Object)ctx.getProperty("impactedUserName"));
        this.fireVirtualEventLogEntries(docForLogEntry, virtualEventName, ctx.getPrincipal(), impactedUserName, ctx.getCoreSession());
    }

    protected DocumentModel handleBeforeDocUpdate(DocumentEventContext ctx, DocumentModel doc) {
        BlobHolder bh;
        BlobHolder previousBh;
        boolean blobRemoved = false;
        DocumentModel previousDoc = (DocumentModel)ctx.getProperty("previousDocumentModel");
        if (previousDoc != null && (previousBh = (BlobHolder)previousDoc.getAdapter(BlobHolder.class)) != null && (bh = (BlobHolder)doc.getAdapter(BlobHolder.class)) != null) {
            boolean bl = blobRemoved = previousBh.getBlob() != null && bh.getBlob() == null;
        }
        if (blobRemoved) {
            return previousDoc;
        }
        return null;
    }

    protected boolean handleLifeCycleTransition(DocumentEventContext ctx) {
        String transition = (String)((Object)ctx.getProperty("transition"));
        return transition != null && "delete".equals(transition);
    }

    protected boolean handleAboutToRemove(DocumentModel doc) {
        return !"deleted".equals(doc.getCurrentLifeCycleState());
    }

    protected void fireVirtualEventLogEntries(DocumentModel doc, String eventName, Principal principal, String impactedUserName, CoreSession session) {
        if (Framework.getService(AuditLogger.class) == null) {
            return;
        }
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        Date currentDate = Calendar.getInstance(NuxeoDriveManagerImpl.UTC).getTime();
        FileSystemItem fsItem = this.getFileSystemItem(doc, eventName);
        if (fsItem == null) {
            if ("securityUpdated".equals(eventName)) {
                for (DocumentModel childSyncRoot : this.getChildSyncRoots(doc, session)) {
                    FileSystemItem childSyncRootFSItem = this.getFileSystemItem(childSyncRoot, eventName);
                    if (childSyncRootFSItem == null) continue;
                    entries.add(this.computeLogEntry(eventName, currentDate, childSyncRoot.getId(), childSyncRoot.getPathAsString(), principal.getName(), childSyncRoot.getType(), childSyncRoot.getRepositoryName(), childSyncRoot.getCurrentLifeCycleState(), impactedUserName, childSyncRootFSItem));
                }
            }
        } else {
            entries.add(this.computeLogEntry(eventName, currentDate, doc.getId(), doc.getPathAsString(), principal.getName(), doc.getType(), doc.getRepositoryName(), doc.getCurrentLifeCycleState(), impactedUserName, fsItem));
        }
        if (!entries.isEmpty()) {
            EventContextImpl eventContext = new EventContextImpl(entries.toArray());
            Event event = eventContext.newEvent("virtualEventCreated");
            ((EventProducer)Framework.getService(EventProducer.class)).fireEvent(event);
        }
    }

    protected FileSystemItem getFileSystemItem(DocumentModel doc, String eventName) {
        try {
            return ((FileSystemItemAdapterService)Framework.getLocalService(FileSystemItemAdapterService.class)).getFileSystemItem(doc, true, true, false);
        }
        catch (RootlessItemException e) {
            return null;
        }
        catch (NuxeoDriveContribException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Either Nuxeo Drive contributions are missing or the FileSystemItemAdapterService component is not ready (application has nor started yet) => ignoring event '%s'.", eventName));
            }
            return null;
        }
    }

    protected List<DocumentModel> getChildSyncRoots(DocumentModel doc, CoreSession session) {
        String nxql = "SELECT * FROM Document WHERE ecm:mixinType = 'DriveSynchronized' AND ecm:currentLifeCycleState != 'deleted' AND ecm:isVersion = 0 AND ecm:path STARTSWITH " + NXQL.escapeString((String)doc.getPathAsString());
        return session.query(nxql);
    }

    protected LogEntry computeLogEntry(String eventName, Date eventDate, String docId, String docPath, String principal, String docType, String repositoryName, String currentLifeCycleState, String impactedUserName, FileSystemItem fsItem) {
        AuditLogger logger = (AuditLogger)Framework.getService(AuditLogger.class);
        LogEntry entry = logger.newLogEntry();
        entry.setEventId(eventName);
        entry.setEventDate(eventDate);
        entry.setCategory("NuxeoDrive");
        entry.setDocUUID(docId);
        entry.setDocPath(docPath);
        entry.setPrincipalName(principal);
        entry.setDocType(docType);
        entry.setRepositoryId(repositoryName);
        entry.setDocLifeCycle(currentLifeCycleState);
        HashMap<String, ExtendedInfo> extendedInfos = new HashMap<String, ExtendedInfo>();
        if (impactedUserName != null) {
            extendedInfos.put("impactedUserName", logger.newExtendedInfo((Serializable)((Object)impactedUserName)));
        }
        extendedInfos.put("fileSystemItemId", logger.newExtendedInfo((Serializable)((Object)fsItem.getId())));
        extendedInfos.put("fileSystemItemName", logger.newExtendedInfo((Serializable)((Object)fsItem.getName())));
        entry.setExtendedInfos(extendedInfos);
        return entry;
    }
}

