/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.drive.service.FileSystemChangeSummary;
import org.nuxeo.drive.service.FileSystemItemChange;
import org.nuxeo.drive.service.impl.FileSystemItemChangeListDeserializer;
import org.nuxeo.ecm.core.api.IdRef;

public class FileSystemChangeSummaryImpl
implements FileSystemChangeSummary {
    private static final long serialVersionUID = 1L;
    protected List<FileSystemItemChange> fileSystemChanges;
    protected Long syncDate = null;
    protected Long upperBound = null;
    protected Boolean hasTooManyChanges = Boolean.FALSE;
    protected String activeSynchronizationRootDefinitions;

    public FileSystemChangeSummaryImpl() {
    }

    public FileSystemChangeSummaryImpl(List<FileSystemItemChange> fileSystemChanges, Map<String, Set<IdRef>> activeRootRefs, Long syncDate, Long upperBound, Boolean tooManyChanges) {
        this.fileSystemChanges = fileSystemChanges;
        this.syncDate = syncDate;
        this.upperBound = upperBound;
        this.hasTooManyChanges = tooManyChanges;
        ArrayList<String> rootDefinitions = new ArrayList<String>();
        for (Map.Entry<String, Set<IdRef>> entry : activeRootRefs.entrySet()) {
            for (IdRef ref : entry.getValue()) {
                rootDefinitions.add(String.format("%s:%s", entry.getKey(), ref.toString()));
            }
        }
        this.activeSynchronizationRootDefinitions = StringUtils.join(rootDefinitions, (String)",");
    }

    @Override
    public List<FileSystemItemChange> getFileSystemChanges() {
        return this.fileSystemChanges;
    }

    @Override
    @JsonDeserialize(using=FileSystemItemChangeListDeserializer.class)
    public void setFileSystemChanges(List<FileSystemItemChange> changes) {
        this.fileSystemChanges = changes;
    }

    @Override
    public Long getSyncDate() {
        return this.syncDate;
    }

    @Override
    public Long getUpperBound() {
        return this.upperBound;
    }

    @Override
    public String getActiveSynchronizationRootDefinitions() {
        return this.activeSynchronizationRootDefinitions;
    }

    @Override
    public void setActiveSynchronizationRootDefinitions(String activeSynchronizationRootDefinitions) {
        this.activeSynchronizationRootDefinitions = activeSynchronizationRootDefinitions;
    }

    @Override
    public void setSyncDate(Long syncDate) {
        this.syncDate = syncDate;
    }

    @Override
    public void setUpperBound(Long upperBound) {
        this.upperBound = upperBound;
    }

    @Override
    public void setHasTooManyChanges(Boolean hasTooManyChanges) {
        this.hasTooManyChanges = hasTooManyChanges;
    }

    @Override
    public Boolean getHasTooManyChanges() {
        return this.hasTooManyChanges;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("(");
        sb.append(String.format("upperBound=%d, ", this.getUpperBound()));
        sb.append(String.format("syncDate=%d, ", this.getSyncDate()));
        if (this.hasTooManyChanges.booleanValue()) {
            sb.append("hasTooManyChanges=true");
        } else {
            sb.append(String.format("items=[%s]", StringUtils.join(this.fileSystemChanges, (String)", ")));
        }
        sb.append(")");
        return sb.toString();
    }
}

