/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.hierarchy.userworkspace.factory;

import java.security.Principal;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.impl.DefaultSyncRootFolderItem;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.drive.service.impl.AbstractSyncRootFolderItemFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.api.Framework;

public class UserWorkspaceSyncRootFactory
extends AbstractSyncRootFolderItemFactory {
    protected static final String SYNC_ROOT_PARENT_FACTORY_PARAM = "syncRootParentFactory";
    protected String syncRootParentFactoryName;

    @Override
    public void handleParameters(Map<String, String> parameters) {
        String syncRootParentFactoryParam = parameters.get(SYNC_ROOT_PARENT_FACTORY_PARAM);
        if (StringUtils.isEmpty((CharSequence)syncRootParentFactoryParam)) {
            throw new NuxeoException(String.format("Factory %s has no %s parameter, please provide it in the factory contribution to set the name of the factory for the parent folder of the synchronization roots.", this.getName(), SYNC_ROOT_PARENT_FACTORY_PARAM));
        }
        this.syncRootParentFactoryName = syncRootParentFactoryParam;
    }

    @Override
    protected FileSystemItem adaptDocument(DocumentModel doc, boolean forceParentItem, FolderItem parentItem, boolean relaxSyncRootConstraint, boolean getLockInfo) {
        return new DefaultSyncRootFolderItem(this.name, parentItem, doc, relaxSyncRootConstraint, getLockInfo);
    }

    @Override
    protected FolderItem getParentItem(DocumentModel doc) {
        Principal principal = doc.getCoreSession().getPrincipal();
        FolderItem parent = this.getFileSystemAdapterService().getVirtualFolderItemFactory(this.syncRootParentFactoryName).getVirtualFolderItem(principal);
        if (parent == null) {
            throw new NuxeoException(String.format("Cannot find the parent of document %s: virtual folder from factory %s.", doc.getId(), this.syncRootParentFactoryName));
        }
        return parent;
    }

    protected FileSystemItemAdapterService getFileSystemAdapterService() {
        return (FileSystemItemAdapterService)Framework.getService(FileSystemItemAdapterService.class);
    }
}

