/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.drive;

import java.io.File;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.nuxeo.common.Environment;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;

@WebObject(type="drive")
@Produces(value={"application/json"})
public class NuxeoDriveObject
extends DefaultObject {
    public static final String NUXEO_DRIVE_CONFIGURATION_FILE = "nuxeo-drive-config.json";

    @GET
    @Path(value="configuration")
    public Response getConfiguration() {
        File configurationFolder = Environment.getDefault().getConfig();
        File configurationFile = new File(configurationFolder, NUXEO_DRIVE_CONFIGURATION_FILE);
        if (!configurationFile.exists()) {
            throw new WebResourceNotFoundException("Nuxeo Drive configuration file not found.");
        }
        return Response.ok().entity((Object)configurationFile).type("application/json").build();
    }
}

