/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.IdRef;

public final class RootDefinitionsHelper {
    private RootDefinitionsHelper() {
    }

    public static Map<String, Set<IdRef>> parseRootDefinitions(String rootDefinitions) {
        LinkedHashMap<String, Set<IdRef>> lastActiveRootRefs = new LinkedHashMap<String, Set<IdRef>>();
        if (rootDefinitions != null) {
            String[] rootDefinitionComponents;
            for (String rootDefinition : rootDefinitionComponents = StringUtils.split((String)rootDefinitions, (String)",")) {
                String[] rootComponents = StringUtils.split((String)rootDefinition, (String)":");
                String repoName = rootComponents[0].trim();
                lastActiveRootRefs.computeIfAbsent(repoName, k -> new HashSet()).add(new IdRef(rootComponents[1].trim()));
            }
        }
        return lastActiveRootRefs;
    }
}

