/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations.test;

import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.user.center.profile.UserProfileService;
import org.nuxeo.runtime.api.Framework;

public final class NuxeoDriveIntegrationTestsHelper {
    static final Log log = LogFactory.getLog(NuxeoDriveIntegrationTestsHelper.class);
    public static final String TEST_USER_NAME_PREFIX = "drive";
    public static final String TEST_WORKSPACE_PARENT_NAME = "workspaces";
    public static final String TEST_WORKSPACE_NAME = "nuxeo-drive-test-workspace";
    public static final String TEST_WORKSPACE_TITLE = "Nuxeo Drive Test Workspace";
    public static final String USER_WORKSPACE_PARENT_NAME = "UserWorkspaces";

    private NuxeoDriveIntegrationTestsHelper() {
    }

    public static void cleanUp(CoreSession session) {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        DocumentModelList testUsers = userManager.searchUsers(TEST_USER_NAME_PREFIX);
        for (DocumentModel testUser : testUsers) {
            String testUserName = (String)((Object)testUser.getPropertyValue(userManager.getUserSchemaName() + ":" + userManager.getUserIdField()));
            if (userManager.getPrincipal(testUserName) != null) {
                userManager.deleteUser(testUserName);
            }
            String testUserWorkspaceName = IdUtils.generateId((String)testUserName, (String)"-", (boolean)false, (int)30);
            String testUserWorkspacePath = NuxeoDriveIntegrationTestsHelper.getDefaultDomainPath(session) + "/" + USER_WORKSPACE_PARENT_NAME + "/" + testUserWorkspaceName;
            PathRef testUserWorkspaceRef = new PathRef(testUserWorkspacePath);
            if (!session.exists((DocumentRef)testUserWorkspaceRef)) continue;
            session.removeDocument((DocumentRef)testUserWorkspaceRef);
            session.save();
        }
        String testWorkspacePath = NuxeoDriveIntegrationTestsHelper.getDefaultDomainPath(session) + "/" + TEST_WORKSPACE_PARENT_NAME + "/" + TEST_WORKSPACE_NAME;
        PathRef testWorkspaceDocRef = new PathRef(testWorkspacePath);
        if (session.exists((DocumentRef)testWorkspaceDocRef)) {
            session.removeDocument((DocumentRef)testWorkspaceDocRef);
            session.save();
        }
        ((UserProfileService)Framework.getService(UserProfileService.class)).clearCache();
    }

    public static String getDefaultDomainPath(CoreSession session) {
        String query = "SELECT * FROM Document where ecm:primaryType = 'Domain'";
        DocumentModelList results = session.query(query);
        if (results.isEmpty()) {
            throw new NuxeoException(String.format("Found no domains in repository %s", session.getRepositoryName()));
        }
        if (results.size() > 1 && log.isDebugEnabled()) {
            log.debug((Object)String.format("Found more than one domain in repository %s, using first one.", session.getRepositoryName()));
        }
        DocumentModel defaultDomain = (DocumentModel)results.get(0);
        String defaultDomainPath = defaultDomain.getPathAsString();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Using default domain %s", defaultDomainPath));
        }
        return defaultDomainPath;
    }

    public static void checkOperationAllowed() {
        if (!Framework.isDevModeSet() && !Framework.isTestModeSet() && Framework.getProperty((String)"org.nuxeo.ecm.tester.name") == null) {
            throw new UnsupportedOperationException("This operation cannot be run unless test mode is set.");
        }
    }

    public static void waitForAsyncCompletion() throws InterruptedException {
        if (!((WorkManager)Framework.getService(WorkManager.class)).awaitCompletion(2L, TimeUnit.MINUTES)) {
            throw new AssertionError((Object)"Cannot synch with work manager in 2 minutes");
        }
    }

    public static void waitForAuditIngestion() throws InterruptedException {
        if (!((AuditLogger)Framework.getService(AuditLogger.class)).await(2L, TimeUnit.MINUTES)) {
            throw new AssertionError((Object)"Cannot synch with audi in 2 minutes");
        }
    }
}

