/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.nuxeo.drive.adapter.ScrollFileSystemItemList;
import org.nuxeo.drive.service.FileSystemItemManager;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.runtime.api.Framework;

@Operation(id="NuxeoDrive.ScrollDescendants", category="Services", label="Nuxeo Drive: Scroll descendants")
public class NuxeoDriveScrollDescendants {
    public static final String ID = "NuxeoDrive.ScrollDescendants";
    @Context
    protected OperationContext ctx;
    @Param(name="id")
    protected String id;
    @Param(name="scrollId", required=false)
    protected String scrollId;
    @Param(name="batchSize")
    protected int batchSize;
    @Param(name="keepAlive", required=false)
    protected long keepAlive = 60000L;

    @OperationMethod
    public Blob run() throws IOException {
        FileSystemItemManager fileSystemItemManager = (FileSystemItemManager)Framework.getService(FileSystemItemManager.class);
        ScrollFileSystemItemList descendants = fileSystemItemManager.scrollDescendants(this.id, this.ctx.getPrincipal(), this.scrollId, this.batchSize, this.keepAlive);
        return this.writeJSONBlob(descendants);
    }

    protected Blob writeJSONBlob(ScrollFileSystemItemList scrollFSIList) throws IOException {
        StringWriter writer = new StringWriter();
        JsonFactory factory = new JsonFactory();
        try (JsonGenerator jg = factory.createGenerator((Writer)writer);){
            jg.setCodec((ObjectCodec)new ObjectMapper());
            jg.writeStartObject();
            jg.writeStringField("scrollId", scrollFSIList.getScrollId());
            jg.writeObjectField("fileSystemItems", (Object)scrollFSIList);
            jg.writeEndObject();
        }
        return Blobs.createJSONBlob((String)writer.toString());
    }
}

