/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.seam;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.hierarchy.userworkspace.adapter.UserWorkspaceHelper;
import org.nuxeo.drive.seam.DesktopPackageDefinition;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.ecm.tokenauth.service.TokenAuthenticationService;
import org.nuxeo.ecm.user.center.UserCenterViewManager;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.contentbrowser.DocumentActions;
import org.nuxeo.runtime.api.Framework;

@Name(value="nuxeoDriveActions")
@Scope(value=ScopeType.PAGE)
@Install(precedence=10)
public class NuxeoDriveActions
extends InputController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LogManager.getLogger(NuxeoDriveActions.class);
    public static final String NUXEO_DRIVE_APPLICATION_NAME = "Nuxeo Drive";
    protected static final String IS_UNDER_SYNCHRONIZATION_ROOT = "nuxeoDriveIsUnderSynchronizationRoot";
    protected static final String CURRENT_SYNCHRONIZATION_ROOT = "nuxeoDriveCurrentSynchronizationRoot";
    public static final String NXDRIVE_PROTOCOL = "nxdrive";
    public static final String PROTOCOL_COMMAND_EDIT = "edit";
    @Deprecated
    public static final String DESKTOP_PACKAGE_URL_LATEST_SEGMENT = "latest";
    public static final String DESKTOP_PACKAGE_PREFIX = "nuxeo-drive.";
    public static final String MSI_EXTENSION = "exe";
    public static final String DMG_EXTENSION = "dmg";
    public static final String WINDOWS_PLATFORM = "windows";
    public static final String OSX_PLATFORM = "osx";
    private static final String DRIVE_METADATA_VIEW = "view_drive_metadata";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected transient UserCenterViewManager userCenterViews;
    @In(create=true)
    protected transient DocumentActions documentActions;

    @Factory(value="nuxeoDriveCurrentSynchronizationRoot", scope=ScopeType.EVENT)
    public DocumentModel getCurrentSynchronizationRoot() {
        Context cache = Contexts.getEventContext();
        Boolean isUnderSync = (Boolean)cache.get(IS_UNDER_SYNCHRONIZATION_ROOT);
        if (isUnderSync == null) {
            NuxeoDriveManager driveManager = (NuxeoDriveManager)Framework.getService(NuxeoDriveManager.class);
            Set references = driveManager.getSynchronizationRootReferences(this.documentManager);
            DocumentModelList path = this.navigationContext.getCurrentPath();
            DocumentModel root = null;
            for (DocumentModel parent : path) {
                if (!references.contains(parent.getRef())) continue;
                root = parent;
                break;
            }
            cache.set(CURRENT_SYNCHRONIZATION_ROOT, root);
            cache.set(IS_UNDER_SYNCHRONIZATION_ROOT, (Object)(root != null ? 1 : 0));
        }
        return (DocumentModel)cache.get(CURRENT_SYNCHRONIZATION_ROOT);
    }

    public boolean canEditDocument(DocumentModel doc) {
        if (doc == null || !this.documentManager.exists(doc.getRef())) {
            return false;
        }
        if (doc.isFolder() || doc.isProxy()) {
            return false;
        }
        if (!this.documentManager.hasPermission(doc.getRef(), "Write")) {
            return false;
        }
        return this.getFileSystemItem(doc) != null;
    }

    public boolean canEditBlob(DocumentModel doc, String xPath) {
        return this.canEditDocument(doc) && doc.getPropertyValue(xPath) instanceof Blob;
    }

    public boolean hasOneDriveToken(NuxeoPrincipal user) throws UnsupportedEncodingException {
        TokenAuthenticationService tokenService = (TokenAuthenticationService)Framework.getService(TokenAuthenticationService.class);
        for (DocumentModel token : tokenService.getTokenBindings(user.getName())) {
            String applicationName = (String)((Object)token.getPropertyValue("authtoken:applicationName"));
            if (applicationName == null || !NUXEO_DRIVE_APPLICATION_NAME.equals(URLDecoder.decode(applicationName, StandardCharsets.UTF_8.toString()))) continue;
            return true;
        }
        return false;
    }

    public String getDriveEditURL() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return this.getDriveEditURL(currentDocument);
    }

    public String getDriveEditURL(DocumentModel currentDocument) {
        if (currentDocument == null) {
            return null;
        }
        BlobHolder bh = (BlobHolder)currentDocument.getAdapter(BlobHolder.class);
        if (bh == null) {
            throw new NuxeoException(String.format("Document %s (%s) is not a BlobHolder, cannot get Drive Edit URL.", currentDocument.getPathAsString(), currentDocument.getId()));
        }
        Blob blob = bh.getBlob();
        if (blob == null) {
            throw new NuxeoException(String.format("Document %s (%s) has no blob, cannot get Drive Edit URL.", currentDocument.getPathAsString(), currentDocument.getId()));
        }
        return this.getDriveEditURL(currentDocument, blob, null);
    }

    public String getDriveEditURL(DocumentModel doc, String xPath) {
        if (doc == null) {
            return null;
        }
        Serializable obj = doc.getPropertyValue(xPath);
        if (!(obj instanceof Blob)) {
            throw new NuxeoException(String.format("Property %s of document %s (%s) is not a blob, cannot get Drive Edit URL.", xPath, doc.getPathAsString(), doc.getId()));
        }
        Blob blob = (Blob)obj;
        return this.getDriveEditURL(doc, blob, xPath);
    }

    public String getDriveEditURL(DocumentModel doc, Blob blob, String xPath) {
        if (doc == null || blob == null) {
            return null;
        }
        String editURL = "%s://%s/%suser/%s/repo/%s/nxdocid/%s/filename/%s/downloadUrl/%s";
        ServletRequest servletRequest = (ServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        String baseURL = VirtualHostHelper.getBaseURL((ServletRequest)servletRequest).replaceFirst("://", "/");
        String user = this.documentManager.getPrincipal().getName();
        String repo = this.documentManager.getRepositoryName();
        String docId = doc.getId();
        String filename = blob.getFilename();
        filename = filename.replaceAll("(/|\\\\|\\*|<|>|\\?|\"|:|\\|)", "-");
        filename = URIUtils.quoteURIPathComponent((String)filename, (boolean)true);
        DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
        if (xPath == null) {
            xPath = "blobholder:0";
        }
        String downloadUrl = downloadService.getDownloadUrl(doc, xPath, filename);
        return String.format(editURL, NXDRIVE_PROTOCOL, PROTOCOL_COMMAND_EDIT, baseURL, user, repo, docId, filename, downloadUrl);
    }

    public String navigateToUserCenterNuxeoDrive() {
        return this.getUserCenterNuxeoDriveView();
    }

    @Factory(value="canSynchronizeCurrentDocument")
    public boolean canSynchronizeCurrentDocument() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument == null) {
            return false;
        }
        return this.isSyncRootCandidate(currentDocument) && this.getCurrentSynchronizationRoot() == null;
    }

    @Factory(value="canUnSynchronizeCurrentDocument")
    public boolean canUnSynchronizeCurrentDocument() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument == null) {
            return false;
        }
        if (!this.isSyncRootCandidate(currentDocument)) {
            return false;
        }
        DocumentRef currentDocRef = currentDocument.getRef();
        DocumentModel currentSyncRoot = this.getCurrentSynchronizationRoot();
        if (currentSyncRoot == null) {
            return false;
        }
        return currentDocRef.equals(currentSyncRoot.getRef());
    }

    @Factory(value="canNavigateToCurrentSynchronizationRoot")
    public boolean canNavigateToCurrentSynchronizationRoot() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument == null) {
            return false;
        }
        if (currentDocument.isTrashed()) {
            return false;
        }
        DocumentRef currentDocRef = currentDocument.getRef();
        DocumentModel currentSyncRoot = this.getCurrentSynchronizationRoot();
        if (currentSyncRoot == null) {
            return false;
        }
        return !currentDocRef.equals(currentSyncRoot.getRef());
    }

    @Factory(value="currentDocumentUserWorkspace", scope=ScopeType.PAGE)
    public boolean isCurrentDocumentUserWorkspace() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument == null) {
            return false;
        }
        return UserWorkspaceHelper.isUserWorkspace((DocumentModel)currentDocument);
    }

    public String synchronizeCurrentDocument() throws UnsupportedEncodingException {
        NuxeoDriveManager driveManager = (NuxeoDriveManager)Framework.getService(NuxeoDriveManager.class);
        NuxeoPrincipal principal = this.documentManager.getPrincipal();
        DocumentModel newSyncRoot = this.navigationContext.getCurrentDocument();
        driveManager.registerSynchronizationRoot(principal, newSyncRoot, this.documentManager);
        boolean hasOneNuxeoDriveToken = this.hasOneDriveToken(principal);
        if (hasOneNuxeoDriveToken) {
            return null;
        }
        return this.getUserCenterNuxeoDriveView();
    }

    public void unsynchronizeCurrentDocument() {
        NuxeoDriveManager driveManager = (NuxeoDriveManager)Framework.getService(NuxeoDriveManager.class);
        NuxeoPrincipal principal = this.documentManager.getPrincipal();
        DocumentModel syncRoot = this.navigationContext.getCurrentDocument();
        driveManager.unregisterSynchronizationRoot(principal, syncRoot, this.documentManager);
    }

    public String navigateToCurrentSynchronizationRoot() {
        DocumentModel currentRoot = this.getCurrentSynchronizationRoot();
        if (currentRoot == null) {
            return "";
        }
        return this.navigationContext.navigateToDocument(currentRoot);
    }

    public DocumentModelList getSynchronizationRoots() {
        DocumentModelListImpl syncRoots = new DocumentModelListImpl();
        NuxeoDriveManager driveManager = (NuxeoDriveManager)Framework.getService(NuxeoDriveManager.class);
        Set syncRootRefs = driveManager.getSynchronizationRootReferences(this.documentManager);
        for (IdRef syncRootRef : syncRootRefs) {
            syncRoots.add((Object)this.documentManager.getDocument((DocumentRef)syncRootRef));
        }
        return syncRoots;
    }

    public void unsynchronizeRoot(DocumentModel syncRoot) {
        NuxeoDriveManager driveManager = (NuxeoDriveManager)Framework.getService(NuxeoDriveManager.class);
        NuxeoPrincipal principal = this.documentManager.getPrincipal();
        driveManager.unregisterSynchronizationRoot(principal, syncRoot, this.documentManager);
    }

    @Factory(value="nuxeoDriveClientPackages", scope=ScopeType.CONVERSATION)
    public List<DesktopPackageDefinition> getClientPackages() {
        ArrayList<DesktopPackageDefinition> packages = new ArrayList<DesktopPackageDefinition>();
        Object desktopPackageBaseURL = Component.getInstance((String)"desktopPackageBaseURL", (ScopeType)ScopeType.APPLICATION);
        if (desktopPackageBaseURL != ObjectUtils.NULL) {
            String packageName = "nuxeo-drive.dmg";
            String packageURL = desktopPackageBaseURL + packageName;
            packages.add(new DesktopPackageDefinition(packageURL, packageName, OSX_PLATFORM));
            log.debug("Added {} to the list of desktop packages available for download.", (Object)packageURL);
            packageName = "nuxeo-drive.exe";
            packageURL = desktopPackageBaseURL + packageName;
            packages.add(new DesktopPackageDefinition(packageURL, packageName, WINDOWS_PLATFORM));
            log.debug("Added {} to the list of desktop packages available for download.", (Object)packageURL);
        }
        packages.add(new DesktopPackageDefinition("https://github.com/nuxeo/nuxeo-drive#debian-based-distributions-and-other-gnulinux-variants-client", "user.center.nuxeoDrive.platform.ubuntu.docLinkTitle", "ubuntu"));
        return packages;
    }

    @Factory(value="desktopPackageBaseURL", scope=ScopeType.APPLICATION)
    public Object getDesktopPackageBaseURL() {
        String URL = Framework.getProperty((String)"org.nuxeo.drive.update.site.url");
        if (URL == null) {
            return ObjectUtils.NULL;
        }
        StringBuilder sb = new StringBuilder(URL);
        if (!URL.endsWith("/")) {
            sb.append("/");
        }
        return sb.toString();
    }

    protected boolean isSyncRootCandidate(DocumentModel doc) {
        return doc.isFolder() && !doc.isTrashed();
    }

    protected FileSystemItem getFileSystemItem(DocumentModel doc) {
        FileSystemItem fileSystemItem = ((FileSystemItemAdapterService)Framework.getService(FileSystemItemAdapterService.class)).getFileSystemItem(doc, null, false, false, false);
        if (fileSystemItem == null) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((DocumentModel)doc).getPathAsString();
            supplierArray[1] = () -> ((DocumentModel)doc).getId();
            log.debug("Document {} ({}) is not adaptable as a FileSystemItem.", supplierArray);
        }
        return fileSystemItem;
    }

    protected String getUserCenterNuxeoDriveView() {
        this.userCenterViews.setCurrentViewId("userCenterNuxeoDrive");
        return "view_home";
    }

    public String updateCurrentDocument() {
        this.documentActions.updateCurrentDocument();
        return DRIVE_METADATA_VIEW;
    }
}

