/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.adapter.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.ArrayList;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.ScrollFileSystemItemList;
import org.nuxeo.drive.adapter.impl.DocumentBackedFileItem;
import org.nuxeo.drive.adapter.impl.DocumentBackedFolderItem;
import org.nuxeo.drive.adapter.impl.ScrollFileSystemItemListImpl;

public class ScrollFileSystemItemListDeserializer
extends JsonDeserializer<ScrollFileSystemItemList> {
    public ScrollFileSystemItemList deserialize(JsonParser jp, DeserializationContext dc) throws IOException {
        JsonNode rootNode = (JsonNode)jp.readValueAsTree();
        String scrollId = ((TextNode)rootNode.get("scrollId")).textValue();
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode fileSystemItemNodes = (ArrayNode)rootNode.get("fileSystemItems");
        ArrayList<FileSystemItem> fileSystemItems = new ArrayList<FileSystemItem>(fileSystemItemNodes.size());
        for (JsonNode fileSystemItemNode : fileSystemItemNodes) {
            boolean folderish = ((BooleanNode)fileSystemItemNode.get("folder")).booleanValue();
            if (folderish) {
                fileSystemItems.add(this.readValue(mapper, fileSystemItemNode, DocumentBackedFolderItem.class));
                continue;
            }
            fileSystemItems.add(this.readValue(mapper, fileSystemItemNode, DocumentBackedFileItem.class));
        }
        return new ScrollFileSystemItemListImpl(scrollId, fileSystemItems);
    }

    protected <T> T readValue(ObjectMapper mapper, JsonNode node, Class<T> klass) throws IOException {
        try (JsonParser tokens = mapper.treeAsTokens((TreeNode)node);){
            Object object = mapper.readValue(tokens, klass);
            return (T)object;
        }
    }
}

