/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.hierarchy.permission.factory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.hierarchy.permission.adapter.PermissionTopLevelFolderItem;
import org.nuxeo.drive.service.TopLevelFolderItemFactory;
import org.nuxeo.drive.service.impl.AbstractVirtualFolderItemFactory;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;

public class PermissionTopLevelFactory
extends AbstractVirtualFolderItemFactory
implements TopLevelFolderItemFactory {
    private static final Logger log = LogManager.getLogger(PermissionTopLevelFactory.class);
    protected static final String CHILDREN_FACTORIES_PARAM = "childrenFactories";
    protected List<String> childrenFactoryNames = new ArrayList<String>();

    @Override
    public void handleParameters(Map<String, String> parameters) {
        super.handleParameters(parameters);
        String childrenFactoriesParam = parameters.get(CHILDREN_FACTORIES_PARAM);
        if (!StringUtils.isEmpty((CharSequence)childrenFactoriesParam)) {
            this.childrenFactoryNames.addAll(Arrays.asList(childrenFactoriesParam.split(",")));
        } else {
            log.warn("Factory {} has no {} parameter, please provide one in the factory contribution using a comma separated list to set the children factory names.", new Supplier[]{this::getName, () -> CHILDREN_FACTORIES_PARAM});
        }
    }

    @Override
    public FolderItem getVirtualFolderItem(NuxeoPrincipal principal) {
        return this.getTopLevelFolderItem(principal);
    }

    @Override
    public FolderItem getTopLevelFolderItem(NuxeoPrincipal principal) {
        return new PermissionTopLevelFolderItem(this.getName(), principal, this.getFolderName(), this.childrenFactoryNames);
    }
}

