/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations;

import java.io.IOException;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.service.FileSystemItemManager;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.runtime.api.Framework;

@Operation(id="NuxeoDrive.GetFileSystemItem", category="Services", label="Nuxeo Drive: Get file system item", description="Get the file system item with the given id. Return the result as a JSON blob.")
public class NuxeoDriveGetFileSystemItem {
    public static final String ID = "NuxeoDrive.GetFileSystemItem";
    @Context
    protected OperationContext ctx;
    @Param(name="id", description="Id of the file system item to get.")
    protected String id;
    @Param(name="parentId", required=false, description="Optional parent id of the file system item to get. For optimization purpose.")
    protected String parentId;

    @OperationMethod
    public Blob run() throws IOException {
        FileSystemItemManager fileSystemItemManager = (FileSystemItemManager)Framework.getService(FileSystemItemManager.class);
        FileSystemItem fsItem = this.parentId == null ? fileSystemItemManager.getFileSystemItemById(this.id, this.ctx.getPrincipal()) : fileSystemItemManager.getFileSystemItemById(this.id, this.parentId, this.ctx.getPrincipal());
        return Blobs.createJSONBlobFromValue((Object)fsItem);
    }
}

