/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations;

import java.io.IOException;
import javax.mail.internet.ParseException;
import org.nuxeo.drive.adapter.FileItem;
import org.nuxeo.drive.operations.NuxeoDriveOperationHelper;
import org.nuxeo.drive.service.FileSystemItemManager;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.runtime.api.Framework;

@Operation(id="NuxeoDrive.UpdateFile", category="Services", label="Nuxeo Drive: Update file", description="Update the document backing the file system item with the given id with the input blob. Return the file system item backed by the updated document as a JSON blob.")
public class NuxeoDriveUpdateFile {
    public static final String ID = "NuxeoDrive.UpdateFile";
    @Context
    protected OperationContext ctx;
    @Param(name="id", description="Id of the file system item backed by the document to update.")
    protected String id;
    @Param(name="parentId", required=false, description="Optional id of the file system item backed by the parent container of the document to update. For optimization purpose.")
    protected String parentId;

    @OperationMethod
    public Blob run(Blob blob) throws ParseException, IOException {
        FileSystemItemManager fileSystemItemManager = (FileSystemItemManager)Framework.getService(FileSystemItemManager.class);
        NuxeoDriveOperationHelper.normalizeMimeTypeAndEncoding(blob);
        FileItem fileItem = this.parentId == null ? fileSystemItemManager.updateFile(this.id, blob, this.ctx.getPrincipal()) : fileSystemItemManager.updateFile(this.id, this.parentId, blob, this.ctx.getPrincipal());
        return Blobs.createJSONBlobFromValue((Object)fileItem);
    }
}

