/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.adapter.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.impl.AbstractVirtualFolderItem;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.SynchronizationRoots;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.api.Framework;

public class DefaultTopLevelFolderItem
extends AbstractVirtualFolderItem {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LogManager.getLogger(DefaultTopLevelFolderItem.class);

    public DefaultTopLevelFolderItem(String factoryName, NuxeoPrincipal principal, String folderName) {
        super(factoryName, principal, null, null, folderName);
    }

    protected DefaultTopLevelFolderItem() {
    }

    @Override
    public List<FileSystemItem> getChildren() {
        ArrayList<FileSystemItem> children = new ArrayList<FileSystemItem>();
        Map<String, SynchronizationRoots> syncRootsByRepo = ((NuxeoDriveManager)Framework.getService(NuxeoDriveManager.class)).getSynchronizationRoots(this.principal);
        for (String repositoryName : syncRootsByRepo.keySet()) {
            CloseableCoreSession session = CoreInstance.openCoreSession((String)repositoryName, (NuxeoPrincipal)this.principal);
            Throwable throwable = null;
            try {
                Set<IdRef> syncRootRefs = syncRootsByRepo.get(repositoryName).getRefs();
                for (IdRef idRef : syncRootRefs) {
                    if (!session.hasPermission((DocumentRef)idRef, "Read")) {
                        Supplier[] supplierArray = new Supplier[2];
                        supplierArray[0] = () -> ((CloseableCoreSession)session).getPrincipal();
                        supplierArray[1] = () -> idRef;
                        log.debug("User {} has no READ access on synchronization root {}, not including it in children.", supplierArray);
                        continue;
                    }
                    DocumentModel doc = session.getDocument((DocumentRef)idRef);
                    FileSystemItem child = this.getFileSystemItemAdapterService().getFileSystemItem(doc, this, false, false, false);
                    if (child == null) {
                        log.debug("Synchronization root {} cannot be adapted as a FileSystemItem, not including it in children.", (Object)idRef);
                        continue;
                    }
                    log.debug("Including synchronization root {} in children.", (Object)idRef);
                    children.add(child);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (session == null) continue;
                if (throwable != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                session.close();
            }
        }
        Collections.sort(children);
        return children;
    }
}

