/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.hierarchy.permission.factory;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.impl.DefaultSyncRootFolderItem;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.drive.service.impl.AbstractSyncRootFolderItemFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.api.Framework;

public class PermissionSyncRootFactory
extends AbstractSyncRootFolderItemFactory {
    private static final Logger log = LogManager.getLogger(PermissionSyncRootFactory.class);
    protected static final String REQUIRED_PERMISSION_PARAM = "requiredPermission";
    protected static final String USER_SYNC_ROOT_PARENT_FACTORY_PARAM = "userSyncRootParentFactory";
    protected static final String SHARED_SYNC_ROOT_PARENT_FACTORY_PARAM = "sharedSyncRootParentFactory";
    protected String requiredPermission = "Read";
    protected String userSyncRootParentFactoryName;
    protected String sharedSyncRootParentFactoryName;

    @Override
    public void handleParameters(Map<String, String> parameters) {
        String userSyncRootParentFactoryParam;
        String requiredPermissionParam = parameters.get(REQUIRED_PERMISSION_PARAM);
        if (!StringUtils.isEmpty((CharSequence)requiredPermissionParam)) {
            this.requiredPermission = requiredPermissionParam;
        }
        if (StringUtils.isEmpty((CharSequence)(userSyncRootParentFactoryParam = parameters.get(USER_SYNC_ROOT_PARENT_FACTORY_PARAM)))) {
            throw new NuxeoException(String.format("Factory %s has no %s parameter, please provide it in the factory contribution to set the name of the factory for the parent folder of the user's synchronization roots.", this.getName(), USER_SYNC_ROOT_PARENT_FACTORY_PARAM));
        }
        this.userSyncRootParentFactoryName = userSyncRootParentFactoryParam;
        String sharedSyncRootParentFactoryParam = parameters.get(SHARED_SYNC_ROOT_PARENT_FACTORY_PARAM);
        if (StringUtils.isEmpty((CharSequence)sharedSyncRootParentFactoryParam)) {
            throw new NuxeoException(String.format("Factory %s has no %s parameter, please provide it in the factory contribution to set the name of the factory for the parent folder of the user's shared synchronization roots.", this.getName(), SHARED_SYNC_ROOT_PARENT_FACTORY_PARAM));
        }
        this.sharedSyncRootParentFactoryName = sharedSyncRootParentFactoryParam;
    }

    @Override
    public boolean isFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint) {
        CoreSession session = doc.getCoreSession();
        boolean hasRequiredPermission = session.hasPermission(doc.getRef(), this.requiredPermission);
        if (!hasRequiredPermission) {
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = () -> this.requiredPermission;
            supplierArray[1] = () -> ((DocumentModel)doc).getId();
            supplierArray[2] = () -> ((CoreSession)session).getPrincipal();
            log.debug("Required permission {} is not granted on document {} to user {}, it cannot be adapted as a FileSystemItem.", supplierArray);
            return false;
        }
        return super.isFileSystemItem(doc, includeDeleted, relaxSyncRootConstraint) && hasRequiredPermission;
    }

    @Override
    protected FileSystemItem adaptDocument(DocumentModel doc, boolean forceParentId, FolderItem parentItem, boolean relaxSyncRootConstraint, boolean getLockInfo) {
        return new DefaultSyncRootFolderItem(this.name, parentItem, doc, relaxSyncRootConstraint, getLockInfo);
    }

    @Override
    protected FolderItem getParentItem(DocumentModel doc) {
        NuxeoPrincipal principal = doc.getCoreSession().getPrincipal();
        String docCreator = (String)((Object)doc.getPropertyValue("dc:creator"));
        if (principal.getName().equals(docCreator)) {
            FolderItem parent = this.getFileSystemAdapterService().getVirtualFolderItemFactory(this.userSyncRootParentFactoryName).getVirtualFolderItem(principal);
            if (parent == null) {
                throw new NuxeoException(String.format("Cannot find the parent of document %s: virtual folder from factory %s.", doc.getId(), this.userSyncRootParentFactoryName));
            }
            return parent;
        }
        FolderItem parent = this.getFileSystemAdapterService().getVirtualFolderItemFactory(this.sharedSyncRootParentFactoryName).getVirtualFolderItem(principal);
        if (parent == null) {
            throw new NuxeoException(String.format("Cannot find the parent of document %s: virtual folder from factory %s.", doc.getId(), this.sharedSyncRootParentFactoryName));
        }
        return parent;
    }

    protected FileSystemItemAdapterService getFileSystemAdapterService() {
        return (FileSystemItemAdapterService)Framework.getService(FileSystemItemAdapterService.class);
    }
}

