/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.drive.service.TopLevelFolderItemFactory;
import org.nuxeo.drive.service.impl.TopLevelFolderItemFactoryDescriptor;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class TopLevelFolderItemFactoryRegistry
extends ContributionFragmentRegistry<TopLevelFolderItemFactoryDescriptor> {
    private static final Logger log = LogManager.getLogger(TopLevelFolderItemFactoryRegistry.class);
    protected Map<String, TopLevelFolderItemFactory> factories = new HashMap<String, TopLevelFolderItemFactory>();

    public String getContributionId(TopLevelFolderItemFactoryDescriptor contrib) {
        String name = contrib.getName();
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new NuxeoException("Cannot register topLevelFolderItemFactory without a name.");
        }
        return name;
    }

    public void contributionUpdated(String id, TopLevelFolderItemFactoryDescriptor contrib, TopLevelFolderItemFactoryDescriptor newOrigContrib) {
        try {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = contrib::getName;
            log.trace("Putting contribution with class name {} in factory registry.", supplierArray);
            this.factories.put(id, contrib.getFactory());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new NuxeoException("Cannot update topLevelFolderItemFactory contribution.", (Throwable)e);
        }
    }

    public void contributionRemoved(String id, TopLevelFolderItemFactoryDescriptor origContrib) {
        log.trace("Removing contribution with class name {} in factory registry.", (Object)id);
        this.factories.remove(id);
    }

    public TopLevelFolderItemFactoryDescriptor clone(TopLevelFolderItemFactoryDescriptor orig) {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = orig::getName;
        log.trace("Cloning contribution with class name {}.", supplierArray);
        TopLevelFolderItemFactoryDescriptor clone = new TopLevelFolderItemFactoryDescriptor();
        clone.factoryClass = orig.factoryClass;
        clone.parameters = orig.parameters;
        return clone;
    }

    public void merge(TopLevelFolderItemFactoryDescriptor src, TopLevelFolderItemFactoryDescriptor dst) {
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = src::getName;
        supplierArray[1] = dst::getName;
        log.trace("Merging contribution with class name {} to contribution with class name {}", supplierArray);
        if (src.getFactoryClass() != null && !src.getFactoryClass().equals(dst.getFactoryClass())) {
            dst.setFactoryClass(src.getFactoryClass());
        }
        if (!MapUtils.isEmpty(src.getParameters())) {
            for (String name : src.getParameters().keySet()) {
                dst.setParameter(name, src.getparameter(name));
            }
        }
    }

    protected TopLevelFolderItemFactory getActiveFactory(String activeFactory) {
        return this.factories.get(activeFactory);
    }
}

