/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations;

import java.io.IOException;
import javax.mail.internet.ParseException;
import org.nuxeo.drive.adapter.FileItem;
import org.nuxeo.drive.operations.NuxeoDriveOperationHelper;
import org.nuxeo.drive.service.FileSystemItemManager;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.runtime.api.Framework;

@Operation(id="NuxeoDrive.CreateFile", category="Services", label="Nuxeo Drive: Create file", description="Create a document from the input blob in the container backing the file system item with the given id. Return the file system item backed by the created document as a JSON blob.")
public class NuxeoDriveCreateFile {
    public static final String ID = "NuxeoDrive.CreateFile";
    @Context
    protected OperationContext ctx;
    @Param(name="parentId", description="Id of the file system item backed by the parent container.")
    protected String parentId;
    @Param(name="overwrite", required=false, description="Optional, whether to overwrite an existing document with the same title.", values={"false"})
    protected boolean overwrite;

    @OperationMethod
    public Blob run(Blob blob) throws ParseException, IOException {
        FileSystemItemManager fileSystemItemManager = (FileSystemItemManager)Framework.getService(FileSystemItemManager.class);
        NuxeoDriveOperationHelper.normalizeMimeTypeAndEncoding(blob);
        FileItem fileItem = fileSystemItemManager.createFile(this.parentId, blob, this.ctx.getPrincipal(), this.overwrite);
        return Blobs.createJSONBlobFromValue((Object)fileItem);
    }
}

