/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations;

import java.io.IOException;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.service.FileSystemItemManager;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.runtime.api.Framework;

@Operation(id="NuxeoDrive.CreateFolder", category="Services", label="Nuxeo Drive: Create folder", description="Create a container with the given name as title in the container backing the file system item with the given id. Return the file system item backed by the created container as a JSON blob.")
public class NuxeoDriveCreateFolder {
    public static final String ID = "NuxeoDrive.CreateFolder";
    @Context
    protected OperationContext ctx;
    @Param(name="parentId", description="Id of the file system item backed by the parent container.")
    protected String parentId;
    @Param(name="name", description="Title of the container to create.")
    protected String name;
    @Param(name="overwrite", required=false, description="Optional, whether to overwrite an existing container with the same title.", values={"false"})
    protected boolean overwrite;

    @OperationMethod
    public Blob run() throws IOException {
        FileSystemItemManager fileSystemItemManager = (FileSystemItemManager)Framework.getService(FileSystemItemManager.class);
        FolderItem folderItem = fileSystemItemManager.createFolder(this.parentId, this.name, this.ctx.getPrincipal(), this.overwrite);
        return Blobs.createJSONBlobFromValue((Object)folderItem);
    }
}

