/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations;

import org.nuxeo.drive.service.FileSystemItemManager;
import org.nuxeo.ecm.automation.InvalidOperationException;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.runtime.api.Framework;

@Operation(id="NuxeoDrive.Delete", category="Services", label="Nuxeo Drive: Delete", description="Delete the document backing the file system item with the given id.")
public class NuxeoDriveDelete {
    public static final String ID = "NuxeoDrive.Delete";
    @Context
    protected OperationContext ctx;
    @Param(name="id", description="Id of the file system item backed by the document to delete.")
    protected String id;
    @Param(name="parentId", required=false, description="Optional id of the file system item backed by the parent container of the document to delete. For optimization purpose.")
    protected String parentId;

    @OperationMethod
    public void run() throws InvalidOperationException {
        FileSystemItemManager fileSystemItemManager = (FileSystemItemManager)Framework.getService(FileSystemItemManager.class);
        try {
            if (this.parentId == null) {
                fileSystemItemManager.delete(this.id, this.ctx.getPrincipal());
            } else {
                fileSystemItemManager.delete(this.id, this.parentId, this.ctx.getPrincipal());
            }
        }
        catch (UnsupportedOperationException e) {
            throw new InvalidOperationException((Throwable)e);
        }
    }
}

