/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations;

import java.io.IOException;
import java.util.Map;
import org.nuxeo.drive.service.FileSystemChangeSummary;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.impl.RootDefinitionsHelper;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.runtime.api.Framework;

@Operation(id="NuxeoDrive.GetChangeSummary", category="Services", label="Nuxeo Drive: Get change summary", description="Get a summary of document changes in the synchronization roots of the currently authenticated user. Return the result as a JSON blob.")
public class NuxeoDriveGetChangeSummary {
    public static final String ID = "NuxeoDrive.GetChangeSummary";
    @Context
    protected OperationContext ctx;
    @Param(name="lowerBound", required=false, description="Optional lower bound of the interval for which to get the changes. If not provided, the list of document changes will be emtpy, yet the summary will contain the upper bound of the scanned interval. If set to 0, the interval will start from the repository's initialization.", values={"-1"})
    protected Long lowerBound = -1L;
    @Deprecated
    @Param(name="lastSyncActiveRootDefinitions", required=false)
    protected String lastSyncActiveRootDefinitions;

    @OperationMethod
    public Blob run() throws IOException {
        NuxeoDriveManager driveManager = (NuxeoDriveManager)Framework.getService(NuxeoDriveManager.class);
        Map lastActiveRootRefs = RootDefinitionsHelper.parseRootDefinitions((String)this.lastSyncActiveRootDefinitions);
        FileSystemChangeSummary docChangeSummary = driveManager.getChangeSummary(this.ctx.getPrincipal(), lastActiveRootRefs, this.lowerBound.longValue());
        return Blobs.createJSONBlobFromValue((Object)docChangeSummary);
    }
}

