/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations;

import java.io.IOException;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.service.FileSystemItemManager;
import org.nuxeo.ecm.automation.InvalidOperationException;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.runtime.api.Framework;

@Operation(id="NuxeoDrive.Move", category="Services", label="Nuxeo Drive: Move", description="Move the document backing the file system item with the given source id to the document backing the file system item with the given destination id. Return the moved file system item as a JSON blob.")
public class NuxeoDriveMove {
    public static final String ID = "NuxeoDrive.Move";
    @Context
    protected OperationContext ctx;
    @Param(name="srcId", description="Id of the source file system item.")
    protected String srcId;
    @Param(name="destId", description="Id of the destination file system item.")
    protected String destId;

    @OperationMethod
    public Blob run() throws InvalidOperationException, IOException {
        FileSystemItem fsItem;
        FileSystemItemManager fileSystemItemManager = (FileSystemItemManager)Framework.getService(FileSystemItemManager.class);
        try {
            fsItem = fileSystemItemManager.move(this.srcId, this.destId, this.ctx.getPrincipal());
        }
        catch (UnsupportedOperationException e) {
            throw new InvalidOperationException((Throwable)e);
        }
        return Blobs.createJSONBlobFromValue((Object)fsItem);
    }
}

