/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.adapter.impl;

import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.impl.DocumentBackedFolderItem;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.api.Framework;

public class DefaultSyncRootFolderItem
extends DocumentBackedFolderItem {
    private static final long serialVersionUID = 1L;

    public DefaultSyncRootFolderItem(String factoryName, FolderItem parentItem, DocumentModel doc) {
        this(factoryName, parentItem, doc, false);
    }

    public DefaultSyncRootFolderItem(String factoryName, FolderItem parentItem, DocumentModel doc, boolean relaxSyncRootConstraint) {
        this(factoryName, parentItem, doc, relaxSyncRootConstraint, true);
    }

    public DefaultSyncRootFolderItem(String factoryName, FolderItem parentItem, DocumentModel doc, boolean relaxSyncRootConstraint, boolean getLockInfo) {
        super(factoryName, parentItem, doc, relaxSyncRootConstraint, getLockInfo);
        this.canDelete = true;
    }

    protected DefaultSyncRootFolderItem() {
    }

    @Override
    public void delete() {
        try (CloseableCoreSession session = CoreInstance.openCoreSession((String)this.repositoryName, (NuxeoPrincipal)this.principal);){
            DocumentModel doc = this.getDocument((CoreSession)session);
            ((NuxeoDriveManager)Framework.getService(NuxeoDriveManager.class)).unregisterSynchronizationRoot(this.principal, doc, (CoreSession)session);
        }
    }

    @Override
    public boolean canMove(FolderItem dest) {
        return false;
    }

    @Override
    public FileSystemItem move(FolderItem dest) {
        throw new UnsupportedOperationException("Cannot move a synchronization root folder item.");
    }
}

