/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.hierarchy.userworkspace.factory;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.hierarchy.userworkspace.adapter.UserWorkspaceHelper;
import org.nuxeo.drive.hierarchy.userworkspace.adapter.UserWorkspaceTopLevelFolderItem;
import org.nuxeo.drive.service.TopLevelFolderItemFactory;
import org.nuxeo.drive.service.impl.AbstractFileSystemItemFactory;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.runtime.api.Framework;

public class UserWorkspaceTopLevelFactory
extends AbstractFileSystemItemFactory
implements TopLevelFolderItemFactory {
    private static final Logger log = LogManager.getLogger(UserWorkspaceTopLevelFactory.class);
    protected static final String FOLDER_NAME_PARAM = "folderName";
    protected static final String SYNC_ROOT_PARENT_FACTORY_PARAM = "syncRootParentFactory";
    protected static final String DEFAULT_FOLDER_NAME = "Nuxeo Drive";
    protected String folderName = "Nuxeo Drive";
    protected String syncRootParentFactoryName;

    @Override
    public void handleParameters(Map<String, String> parameters) {
        String folderNameParam = parameters.get(FOLDER_NAME_PARAM);
        if (!StringUtils.isEmpty((CharSequence)folderNameParam)) {
            this.folderName = folderNameParam;
        } else {
            log.info("Factory {} has no {} parameter, you can provide one in the factory contribution to avoid using the default value '{}'.", new Supplier[]{this::getName, () -> FOLDER_NAME_PARAM, () -> DEFAULT_FOLDER_NAME});
        }
        String syncRootParentFactoryParam = parameters.get(SYNC_ROOT_PARENT_FACTORY_PARAM);
        if (!StringUtils.isEmpty((CharSequence)syncRootParentFactoryParam)) {
            this.syncRootParentFactoryName = syncRootParentFactoryParam;
        } else {
            log.warn("Factory {} has no {} parameter, please provide one in the factory contribution to set the name of the synchronization root parent factory.", new Supplier[]{this::getName, () -> SYNC_ROOT_PARENT_FACTORY_PARAM});
        }
    }

    @Override
    public boolean isFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint) {
        boolean isUserWorkspace = UserWorkspaceHelper.isUserWorkspace(doc);
        if (!isUserWorkspace) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            log.trace("Document {} is not a user workspace, it cannot be adapted as a FileSystemItem.", supplierArray);
            return false;
        }
        return true;
    }

    @Override
    protected FileSystemItem adaptDocument(DocumentModel doc, boolean forceParentItem, FolderItem parentItem, boolean relaxSyncRootConstraint, boolean getLockInfo) {
        return new UserWorkspaceTopLevelFolderItem(this.getName(), doc, this.folderName, this.syncRootParentFactoryName, relaxSyncRootConstraint, getLockInfo);
    }

    @Override
    public FolderItem getVirtualFolderItem(NuxeoPrincipal principal) {
        return this.getTopLevelFolderItem(principal);
    }

    @Override
    public String getFolderName() {
        return this.folderName;
    }

    @Override
    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    @Override
    public FolderItem getTopLevelFolderItem(NuxeoPrincipal principal) {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        try (CloseableCoreSession session = CoreInstance.openCoreSession((String)repositoryManager.getDefaultRepositoryName(), (NuxeoPrincipal)principal);){
            UserWorkspaceService userWorkspaceService = (UserWorkspaceService)Framework.getService(UserWorkspaceService.class);
            DocumentModel userWorkspace = userWorkspaceService.getCurrentUserPersonalWorkspace((CoreSession)session);
            if (userWorkspace == null) {
                throw new NuxeoException(String.format("No personal workspace found for user %s.", principal.getName()));
            }
            FolderItem folderItem = (FolderItem)this.getFileSystemItem(userWorkspace);
            return folderItem;
        }
    }
}

